@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudtrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property insightType Type of insights to log on a trail. Valid values are: `ApiCallRateInsight` and `ApiErrorRateInsight`.
 */
public data class TrailInsightSelector(
    public val insightType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudtrail.outputs.TrailInsightSelector):
            TrailInsightSelector = TrailInsightSelector(
            insightType = javaType.insightType(),
        )
    }
}
