@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.CloudwatchFunctions.getEventBusPlain
import com.pulumi.aws.cloudwatch.CloudwatchFunctions.getEventConnectionPlain
import com.pulumi.aws.cloudwatch.CloudwatchFunctions.getEventSourcePlain
import com.pulumi.aws.cloudwatch.CloudwatchFunctions.getLogDataProtectionPolicyDocumentPlain
import com.pulumi.aws.cloudwatch.CloudwatchFunctions.getLogGroupPlain
import com.pulumi.aws.cloudwatch.CloudwatchFunctions.getLogGroupsPlain
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetEventBusPlainArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetEventBusPlainArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetEventConnectionPlainArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetEventConnectionPlainArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetEventSourcePlainArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetEventSourcePlainArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetLogDataProtectionPolicyDocumentPlainArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetLogDataProtectionPolicyDocumentPlainArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetLogDataProtectionPolicyDocumentStatement
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetLogGroupPlainArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetLogGroupPlainArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetLogGroupsPlainArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.GetLogGroupsPlainArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetEventBusResult
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetEventConnectionResult
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetEventSourceResult
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetLogDataProtectionPolicyDocumentResult
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetLogGroupResult
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetLogGroupsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetEventBusResult.Companion.toKotlin as getEventBusResultToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetEventConnectionResult.Companion.toKotlin as getEventConnectionResultToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetEventSourceResult.Companion.toKotlin as getEventSourceResultToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetLogDataProtectionPolicyDocumentResult.Companion.toKotlin as getLogDataProtectionPolicyDocumentResultToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetLogGroupResult.Companion.toKotlin as getLogGroupResultToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.GetLogGroupsResult.Companion.toKotlin as getLogGroupsResultToKotlin

public object CloudwatchFunctions {
    /**
     * This data source can be used to fetch information about a specific
     * EventBridge event bus. Use this data source to compute the ARN of
     * an event bus, given the name of the bus.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudwatch.CloudwatchFunctions;
     * import com.pulumi.aws.cloudwatch.inputs.GetEventBusArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudwatchFunctions.getEventBus(GetEventBusArgs.builder()
     *             .name("example-bus-name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEventBus.
     * @return A collection of values returned by getEventBus.
     */
    public suspend fun getEventBus(argument: GetEventBusPlainArgs): GetEventBusResult =
        getEventBusResultToKotlin(getEventBusPlain(argument.toJava()).await())

    /**
     * @see [getEventBus].
     * @param name Friendly EventBridge event bus name.
     * @return A collection of values returned by getEventBus.
     */
    public suspend fun getEventBus(name: String): GetEventBusResult {
        val argument = GetEventBusPlainArgs(
            name = name,
        )
        return getEventBusResultToKotlin(getEventBusPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventBus].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudwatch&#46;kotlin&#46;inputs&#46;GetEventBusPlainArgs].
     * @return A collection of values returned by getEventBus.
     */
    public suspend fun getEventBus(argument: suspend GetEventBusPlainArgsBuilder.() -> Unit):
        GetEventBusResult {
        val builder = GetEventBusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventBusResultToKotlin(getEventBusPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information about an EventBridge connection.
     * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudwatch.CloudwatchFunctions;
     * import com.pulumi.aws.cloudwatch.inputs.GetEventConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = CloudwatchFunctions.getEventConnection(GetEventConnectionArgs.builder()
     *             .name("test")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEventConnection.
     * @return A collection of values returned by getEventConnection.
     */
    public suspend fun getEventConnection(argument: GetEventConnectionPlainArgs):
        GetEventConnectionResult =
        getEventConnectionResultToKotlin(getEventConnectionPlain(argument.toJava()).await())

    /**
     * @see [getEventConnection].
     * @param name Name of the connection.
     * @return A collection of values returned by getEventConnection.
     */
    public suspend fun getEventConnection(name: String): GetEventConnectionResult {
        val argument = GetEventConnectionPlainArgs(
            name = name,
        )
        return getEventConnectionResultToKotlin(getEventConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudwatch&#46;kotlin&#46;inputs&#46;GetEventConnectionPlainArgs].
     * @return A collection of values returned by getEventConnection.
     */
    public suspend
    fun getEventConnection(argument: suspend GetEventConnectionPlainArgsBuilder.() -> Unit):
        GetEventConnectionResult {
        val builder = GetEventConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventConnectionResultToKotlin(getEventConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an EventBridge Partner Event Source. This data source will only return one partner event source. An error will be returned if multiple sources match the same name prefix.
     * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudwatch.CloudwatchFunctions;
     * import com.pulumi.aws.cloudwatch.inputs.GetEventSourceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var examplepartner = CloudwatchFunctions.getEventSource(GetEventSourceArgs.builder()
     *             .namePrefix("aws.partner/examplepartner.com")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEventSource.
     * @return A collection of values returned by getEventSource.
     */
    public suspend fun getEventSource(argument: GetEventSourcePlainArgs): GetEventSourceResult =
        getEventSourceResultToKotlin(getEventSourcePlain(argument.toJava()).await())

    /**
     * @see [getEventSource].
     * @param namePrefix Specifying this limits the results to only those partner event sources with names that start with the specified prefix
     * @return A collection of values returned by getEventSource.
     */
    public suspend fun getEventSource(namePrefix: String? = null): GetEventSourceResult {
        val argument = GetEventSourcePlainArgs(
            namePrefix = namePrefix,
        )
        return getEventSourceResultToKotlin(getEventSourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getEventSource].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudwatch&#46;kotlin&#46;inputs&#46;GetEventSourcePlainArgs].
     * @return A collection of values returned by getEventSource.
     */
    public suspend fun getEventSource(argument: suspend GetEventSourcePlainArgsBuilder.() -> Unit):
        GetEventSourceResult {
        val builder = GetEventSourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventSourceResultToKotlin(getEventSourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Generates a CloudWatch Log Group Data Protection Policy document in JSON format for use with the `aws.cloudwatch.LogDataProtectionPolicy` resource.
     * > For more information about data protection policies, see the [Help protect sensitive log data with masking](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudwatch.CloudwatchFunctions;
     * import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentArgs;
     * import com.pulumi.aws.cloudwatch.LogDataProtectionPolicy;
     * import com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleLogDataProtectionPolicyDocument = CloudwatchFunctions.getLogDataProtectionPolicyDocument(GetLogDataProtectionPolicyDocumentArgs.builder()
     *             .name("Example")
     *             .statements(
     *                 GetLogDataProtectionPolicyDocumentStatementArgs.builder()
     *                     .sid("Audit")
     *                     .dataIdentifiers(
     *                         "arn:aws:dataprotection::aws:data-identifier/EmailAddress",
     *                         "arn:aws:dataprotection::aws:data-identifier/DriversLicense-US")
     *                     .operation(GetLogDataProtectionPolicyDocumentStatementOperationArgs.builder()
     *                         .audit(GetLogDataProtectionPolicyDocumentStatementOperationAuditArgs.builder()
     *                             .findingsDestination(GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationArgs.builder()
     *                                 .cloudwatchLogs(GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsArgs.builder()
     *                                     .logGroup(aws_cloudwatch_log_group.audit().name())
     *                                     .build())
     *                                 .firehose(GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseArgs.builder()
     *                                     .deliveryStream(aws_kinesis_firehose_delivery_stream.audit().name())
     *                                     .build())
     *                                 .s3(GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Args.builder()
     *                                     .bucket(aws_s3_bucket.audit().bucket())
     *                                     .build())
     *                                 .build())
     *                             .build())
     *                         .build())
     *                     .build(),
     *                 GetLogDataProtectionPolicyDocumentStatementArgs.builder()
     *                     .sid("Deidentify")
     *                     .dataIdentifiers(
     *                         "arn:aws:dataprotection::aws:data-identifier/EmailAddress",
     *                         "arn:aws:dataprotection::aws:data-identifier/DriversLicense-US")
     *                     .operation(GetLogDataProtectionPolicyDocumentStatementOperationArgs.builder()
     *                         .deidentify(GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyArgs.builder()
     *                             .maskConfig()
     *                             .build())
     *                         .build())
     *                     .build())
     *             .build());
     *         var exampleLogDataProtectionPolicy = new LogDataProtectionPolicy("exampleLogDataProtectionPolicy", LogDataProtectionPolicyArgs.builder()
     *             .logGroupName(aws_cloudwatch_log_group.example().name())
     *             .policyDocument(exampleLogDataProtectionPolicyDocument.applyValue(getLogDataProtectionPolicyDocumentResult -> getLogDataProtectionPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLogDataProtectionPolicyDocument.
     * @return A collection of values returned by getLogDataProtectionPolicyDocument.
     */
    public suspend
    fun getLogDataProtectionPolicyDocument(argument: GetLogDataProtectionPolicyDocumentPlainArgs):
        GetLogDataProtectionPolicyDocumentResult =
        getLogDataProtectionPolicyDocumentResultToKotlin(getLogDataProtectionPolicyDocumentPlain(argument.toJava()).await())

    /**
     * @see [getLogDataProtectionPolicyDocument].
     * @param description
     * @param name The name of the data protection policy document.
     * @param statements Configures the data protection policy.
     * > There must be exactly two statements: the first with an `audit` operation, and the second with a `deidentify` operation.
     * The following arguments are optional:
     * @param version
     * @return A collection of values returned by getLogDataProtectionPolicyDocument.
     */
    public suspend fun getLogDataProtectionPolicyDocument(
        description: String? = null,
        name: String,
        statements: List<GetLogDataProtectionPolicyDocumentStatement>,
        version: String? = null,
    ): GetLogDataProtectionPolicyDocumentResult {
        val argument = GetLogDataProtectionPolicyDocumentPlainArgs(
            description = description,
            name = name,
            statements = statements,
            version = version,
        )
        return getLogDataProtectionPolicyDocumentResultToKotlin(getLogDataProtectionPolicyDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogDataProtectionPolicyDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudwatch&#46;kotlin&#46;inputs&#46;GetLogDataProtectionPolicyDocumentPlainArgs].
     * @return A collection of values returned by getLogDataProtectionPolicyDocument.
     */
    public suspend
    fun getLogDataProtectionPolicyDocument(argument: suspend GetLogDataProtectionPolicyDocumentPlainArgsBuilder.() -> Unit):
        GetLogDataProtectionPolicyDocumentResult {
        val builder = GetLogDataProtectionPolicyDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogDataProtectionPolicyDocumentResultToKotlin(getLogDataProtectionPolicyDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an AWS Cloudwatch Log Group
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudwatch.CloudwatchFunctions;
     * import com.pulumi.aws.cloudwatch.inputs.GetLogGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudwatchFunctions.getLogGroup(GetLogGroupArgs.builder()
     *             .name("MyImportantLogs")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLogGroup.
     * @return A collection of values returned by getLogGroup.
     */
    public suspend fun getLogGroup(argument: GetLogGroupPlainArgs): GetLogGroupResult =
        getLogGroupResultToKotlin(getLogGroupPlain(argument.toJava()).await())

    /**
     * @see [getLogGroup].
     * @param name Name of the Cloudwatch log group
     * @param tags Map of tags to assign to the resource.
     * @return A collection of values returned by getLogGroup.
     */
    public suspend fun getLogGroup(name: String, tags: Map<String, String>? = null):
        GetLogGroupResult {
        val argument = GetLogGroupPlainArgs(
            name = name,
            tags = tags,
        )
        return getLogGroupResultToKotlin(getLogGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudwatch&#46;kotlin&#46;inputs&#46;GetLogGroupPlainArgs].
     * @return A collection of values returned by getLogGroup.
     */
    public suspend fun getLogGroup(argument: suspend GetLogGroupPlainArgsBuilder.() -> Unit):
        GetLogGroupResult {
        val builder = GetLogGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogGroupResultToKotlin(getLogGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of AWS Cloudwatch Log Groups
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudwatch.CloudwatchFunctions;
     * import com.pulumi.aws.cloudwatch.inputs.GetLogGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudwatchFunctions.getLogGroups(GetLogGroupsArgs.builder()
     *             .logGroupNamePrefix("/MyImportantLogs")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLogGroups.
     * @return A collection of values returned by getLogGroups.
     */
    public suspend fun getLogGroups(argument: GetLogGroupsPlainArgs): GetLogGroupsResult =
        getLogGroupsResultToKotlin(getLogGroupsPlain(argument.toJava()).await())

    /**
     * @see [getLogGroups].
     * @param logGroupNamePrefix Group prefix of the Cloudwatch log groups to list
     * @return A collection of values returned by getLogGroups.
     */
    public suspend fun getLogGroups(logGroupNamePrefix: String? = null): GetLogGroupsResult {
        val argument = GetLogGroupsPlainArgs(
            logGroupNamePrefix = logGroupNamePrefix,
        )
        return getLogGroupsResultToKotlin(getLogGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudwatch&#46;kotlin&#46;inputs&#46;GetLogGroupsPlainArgs].
     * @return A collection of values returned by getLogGroups.
     */
    public suspend fun getLogGroups(argument: suspend GetLogGroupsPlainArgsBuilder.() -> Unit):
        GetLogGroupsResult {
        val builder = GetLogGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogGroupsResultToKotlin(getLogGroupsPlain(builtArgument.toJava()).await())
    }
}
