@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Dashboard].
 */
@PulumiTagMarker
public class DashboardResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DashboardArgs = DashboardArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DashboardArgsBuilder.() -> Unit) {
        val builder = DashboardArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Dashboard {
        val builtJavaResource = com.pulumi.aws.cloudwatch.Dashboard(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Dashboard(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Dashboard resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.Dashboard;
 * import com.pulumi.aws.cloudwatch.DashboardArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Dashboard("main", DashboardArgs.builder()
 *             .dashboardName("my-dashboard")
 *             .dashboardBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("widgets", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("type", "metric"),
 *                             jsonProperty("x", 0),
 *                             jsonProperty("y", 0),
 *                             jsonProperty("width", 12),
 *                             jsonProperty("height", 6),
 *                             jsonProperty("properties", jsonObject(
 *                                 jsonProperty("metrics", jsonArray(jsonArray(
 *                                     "AWS/EC2",
 *                                     "CPUUtilization",
 *                                     "InstanceId",
 *                                     "i-012345"
 *                                 ))),
 *                                 jsonProperty("period", 300),
 *                                 jsonProperty("stat", "Average"),
 *                                 jsonProperty("region", "us-east-1"),
 *                                 jsonProperty("title", "EC2 Instance CPU")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("type", "text"),
 *                             jsonProperty("x", 0),
 *                             jsonProperty("y", 7),
 *                             jsonProperty("width", 3),
 *                             jsonProperty("height", 3),
 *                             jsonProperty("properties", jsonObject(
 *                                 jsonProperty("markdown", "Hello world")
 *                             ))
 *                         )
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch dashboards using the `dashboard_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/dashboard:Dashboard sample dashboard_name
 * ```
 *
 */
public class Dashboard internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.Dashboard,
) : KotlinCustomResource(javaResource, DashboardMapper) {
    /**
     * The Amazon Resource Name (ARN) of the dashboard.
     */
    public val dashboardArn: Output<String>
        get() = javaResource.dashboardArn().applyValue({ args0 -> args0 })

    /**
     * The detailed information about the dashboard, including what widgets are included and their location on the dashboard. You can read more about the body structure in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
     */
    public val dashboardBody: Output<String>
        get() = javaResource.dashboardBody().applyValue({ args0 -> args0 })

    /**
     * The name of the dashboard.
     */
    public val dashboardName: Output<String>
        get() = javaResource.dashboardName().applyValue({ args0 -> args0 })
}

public object DashboardMapper : ResourceMapper<Dashboard> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.Dashboard::class == javaResource::class

    override fun map(javaResource: Resource): Dashboard = Dashboard(
        javaResource as
            com.pulumi.aws.cloudwatch.Dashboard,
    )
}

/**
 * @see [Dashboard].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Dashboard].
 */
public suspend fun dashboard(name: String, block: suspend DashboardResourceBuilder.() -> Unit):
    Dashboard {
    val builder = DashboardResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Dashboard].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dashboard(name: String): Dashboard {
    val builder = DashboardResourceBuilder()
    builder.name(name)
    return builder.build()
}
