@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.DashboardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Dashboard resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.Dashboard;
 * import com.pulumi.aws.cloudwatch.DashboardArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Dashboard("main", DashboardArgs.builder()
 *             .dashboardName("my-dashboard")
 *             .dashboardBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("widgets", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("type", "metric"),
 *                             jsonProperty("x", 0),
 *                             jsonProperty("y", 0),
 *                             jsonProperty("width", 12),
 *                             jsonProperty("height", 6),
 *                             jsonProperty("properties", jsonObject(
 *                                 jsonProperty("metrics", jsonArray(jsonArray(
 *                                     "AWS/EC2",
 *                                     "CPUUtilization",
 *                                     "InstanceId",
 *                                     "i-012345"
 *                                 ))),
 *                                 jsonProperty("period", 300),
 *                                 jsonProperty("stat", "Average"),
 *                                 jsonProperty("region", "us-east-1"),
 *                                 jsonProperty("title", "EC2 Instance CPU")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("type", "text"),
 *                             jsonProperty("x", 0),
 *                             jsonProperty("y", 7),
 *                             jsonProperty("width", 3),
 *                             jsonProperty("height", 3),
 *                             jsonProperty("properties", jsonObject(
 *                                 jsonProperty("markdown", "Hello world")
 *                             ))
 *                         )
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch dashboards using the `dashboard_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/dashboard:Dashboard sample dashboard_name
 * ```
 * @property dashboardBody The detailed information about the dashboard, including what widgets are included and their location on the dashboard. You can read more about the body structure in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
 * @property dashboardName The name of the dashboard.
 */
public data class DashboardArgs(
    public val dashboardBody: Output<String>? = null,
    public val dashboardName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.DashboardArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.DashboardArgs =
        com.pulumi.aws.cloudwatch.DashboardArgs.builder()
            .dashboardBody(dashboardBody?.applyValue({ args0 -> args0 }))
            .dashboardName(dashboardName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DashboardArgs].
 */
@PulumiTagMarker
public class DashboardArgsBuilder internal constructor() {
    private var dashboardBody: Output<String>? = null

    private var dashboardName: Output<String>? = null

    /**
     * @param value The detailed information about the dashboard, including what widgets are included and their location on the dashboard. You can read more about the body structure in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
     */
    @JvmName("yykmbvyigdomthdn")
    public suspend fun dashboardBody(`value`: Output<String>) {
        this.dashboardBody = value
    }

    /**
     * @param value The name of the dashboard.
     */
    @JvmName("etvyyaftheyuwldc")
    public suspend fun dashboardName(`value`: Output<String>) {
        this.dashboardName = value
    }

    /**
     * @param value The detailed information about the dashboard, including what widgets are included and their location on the dashboard. You can read more about the body structure in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
     */
    @JvmName("uwowxftssrudmlim")
    public suspend fun dashboardBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardBody = mapped
    }

    /**
     * @param value The name of the dashboard.
     */
    @JvmName("vayatcwlnmnonygc")
    public suspend fun dashboardName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardName = mapped
    }

    internal fun build(): DashboardArgs = DashboardArgs(
        dashboardBody = dashboardBody,
        dashboardName = dashboardName,
    )
}
