@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventApiDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge event API Destination resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventApiDestination;
 * import com.pulumi.aws.cloudwatch.EventApiDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventApiDestination("test", EventApiDestinationArgs.builder()
 *             .description("An API Destination")
 *             .invocationEndpoint("https://api.destination.com/endpoint")
 *             .httpMethod("POST")
 *             .invocationRateLimitPerSecond(20)
 *             .connectionArn(aws_cloudwatch_event_connection.test().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge API Destinations using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventApiDestination:EventApiDestination test api-destination
 * ```
 * @property connectionArn ARN of the EventBridge Connection to use for the API Destination.
 * @property description The description of the new API Destination. Maximum of 512 characters.
 * @property httpMethod Select the HTTP method used for the invocation endpoint, such as GET, POST, PUT, etc.
 * @property invocationEndpoint URL endpoint to invoke as a target. This could be a valid endpoint generated by a partner service. You can include "*" as path parameters wildcards to be set from the Target HttpParameters.
 * @property invocationRateLimitPerSecond Enter the maximum number of invocations per second to allow for this destination. Enter a value greater than 0 (default 300).
 * @property name The name of the new API Destination. The name must be unique for your account. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
 */
public data class EventApiDestinationArgs(
    public val connectionArn: Output<String>? = null,
    public val description: Output<String>? = null,
    public val httpMethod: Output<String>? = null,
    public val invocationEndpoint: Output<String>? = null,
    public val invocationRateLimitPerSecond: Output<Int>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventApiDestinationArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventApiDestinationArgs =
        com.pulumi.aws.cloudwatch.EventApiDestinationArgs.builder()
            .connectionArn(connectionArn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .httpMethod(httpMethod?.applyValue({ args0 -> args0 }))
            .invocationEndpoint(invocationEndpoint?.applyValue({ args0 -> args0 }))
            .invocationRateLimitPerSecond(invocationRateLimitPerSecond?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventApiDestinationArgs].
 */
@PulumiTagMarker
public class EventApiDestinationArgsBuilder internal constructor() {
    private var connectionArn: Output<String>? = null

    private var description: Output<String>? = null

    private var httpMethod: Output<String>? = null

    private var invocationEndpoint: Output<String>? = null

    private var invocationRateLimitPerSecond: Output<Int>? = null

    private var name: Output<String>? = null

    /**
     * @param value ARN of the EventBridge Connection to use for the API Destination.
     */
    @JvmName("spugmehrdevyyytu")
    public suspend fun connectionArn(`value`: Output<String>) {
        this.connectionArn = value
    }

    /**
     * @param value The description of the new API Destination. Maximum of 512 characters.
     */
    @JvmName("ailvgwyowexocwmt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Select the HTTP method used for the invocation endpoint, such as GET, POST, PUT, etc.
     */
    @JvmName("rcvsnjgynjeelthb")
    public suspend fun httpMethod(`value`: Output<String>) {
        this.httpMethod = value
    }

    /**
     * @param value URL endpoint to invoke as a target. This could be a valid endpoint generated by a partner service. You can include "*" as path parameters wildcards to be set from the Target HttpParameters.
     */
    @JvmName("nuynoblusulmannp")
    public suspend fun invocationEndpoint(`value`: Output<String>) {
        this.invocationEndpoint = value
    }

    /**
     * @param value Enter the maximum number of invocations per second to allow for this destination. Enter a value greater than 0 (default 300).
     */
    @JvmName("otuqwaxeicwwnodg")
    public suspend fun invocationRateLimitPerSecond(`value`: Output<Int>) {
        this.invocationRateLimitPerSecond = value
    }

    /**
     * @param value The name of the new API Destination. The name must be unique for your account. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    @JvmName("nqnwjgwtittfyyuf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ARN of the EventBridge Connection to use for the API Destination.
     */
    @JvmName("kdqaroidkryiannw")
    public suspend fun connectionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionArn = mapped
    }

    /**
     * @param value The description of the new API Destination. Maximum of 512 characters.
     */
    @JvmName("tuotpqledxjxfree")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Select the HTTP method used for the invocation endpoint, such as GET, POST, PUT, etc.
     */
    @JvmName("ejxdjetqnrbdtplp")
    public suspend fun httpMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMethod = mapped
    }

    /**
     * @param value URL endpoint to invoke as a target. This could be a valid endpoint generated by a partner service. You can include "*" as path parameters wildcards to be set from the Target HttpParameters.
     */
    @JvmName("gycikaoqcxatdylu")
    public suspend fun invocationEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationEndpoint = mapped
    }

    /**
     * @param value Enter the maximum number of invocations per second to allow for this destination. Enter a value greater than 0 (default 300).
     */
    @JvmName("aycwulhvrfwksmlo")
    public suspend fun invocationRateLimitPerSecond(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationRateLimitPerSecond = mapped
    }

    /**
     * @param value The name of the new API Destination. The name must be unique for your account. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    @JvmName("gjupnbfhlthyssvx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EventApiDestinationArgs = EventApiDestinationArgs(
        connectionArn = connectionArn,
        description = description,
        httpMethod = httpMethod,
        invocationEndpoint = invocationEndpoint,
        invocationRateLimitPerSecond = invocationRateLimitPerSecond,
        name = name,
    )
}
