@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventArchive].
 */
@PulumiTagMarker
public class EventArchiveResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventArchiveArgs = EventArchiveArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventArchiveArgsBuilder.() -> Unit) {
        val builder = EventArchiveArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventArchive {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventArchive(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventArchive(builtJavaResource)
    }
}

/**
 * Provides an EventBridge event archive resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.cloudwatch.EventArchive;
 * import com.pulumi.aws.cloudwatch.EventArchiveArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderEventBus = new EventBus("orderEventBus");
 *         var orderEventArchive = new EventArchive("orderEventArchive", EventArchiveArgs.builder()
 *             .eventSourceArn(orderEventBus.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Example all optional arguments
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const orderEventBus = new aws.cloudwatch.EventBus("orderEventBus", {});
 * const orderEventArchive = new aws.cloudwatch.EventArchive("orderEventArchive", {
 *     description: "Archived events from order service",
 *     eventSourceArn: orderEventBus.arn,
 *     retentionDays: 7,
 *     eventPattern: JSON.stringify({
 *         source: ["company&#46;team&#46;order"],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * order_event_bus = aws.cloudwatch.EventBus("orderEventBus")
 * order_event_archive = aws.cloudwatch.EventArchive("orderEventArchive",
 *     description="Archived events from order service",
 *     event_source_arn=order_event_bus.arn,
 *     retention_days=7,
 *     event_pattern=json.dumps({
 *         "source": ["company&#46;team&#46;order"],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderEventBus = new Aws.CloudWatch.EventBus("orderEventBus");
 *     var orderEventArchive = new Aws.CloudWatch.EventArchive("orderEventArchive", new()
 *     {
 *         Description = "Archived events from order service",
 *         EventSourceArn = orderEventBus.Arn,
 *         RetentionDays = 7,
 *         EventPattern = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["source"] = new[]
 *             {
 *                 "company.team.order",
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		orderEventBus, err := cloudwatch.NewEventBus(ctx, "orderEventBus", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"source": []string{
 * 				"company.team.order",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = cloudwatch.NewEventArchive(ctx, "orderEventArchive", &cloudwatch.EventArchiveArgs{
 * 			Description:    pulumi.String("Archived events from order service"),
 * 			EventSourceArn: orderEventBus.Arn,
 * 			RetentionDays:  pulumi.Int(7),
 * 			EventPattern:   pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.cloudwatch.EventArchive;
 * import com.pulumi.aws.cloudwatch.EventArchiveArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderEventBus = new EventBus("orderEventBus");
 *         var orderEventArchive = new EventArchive("orderEventArchive", EventArchiveArgs.builder()
 *             .description("Archived events from order service")
 *             .eventSourceArn(orderEventBus.arn())
 *             .retentionDays(7)
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("source", jsonArray("company.team.order"))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   orderEventBus:
 *     type: aws:cloudwatch:EventBus
 *   orderEventArchive:
 *     type: aws:cloudwatch:EventArchive
 *     properties:
 *       description: Archived events from order service
 *       eventSourceArn: ${orderEventBus.arn}
 *       retentionDays: 7
 *       eventPattern:
 *         fn::toJSON:
 *           source:
 *             - company.team.order
 * ```
 * ## Import
 * Using `pulumi import`, import an EventBridge archive using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventArchive:EventArchive imported_event_archive order-archive
 * ```
 *
 */
public class EventArchive internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventArchive,
) : KotlinCustomResource(javaResource, EventArchiveMapper) {
    /**
     * The Amazon Resource Name (ARN) of the event archive.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the new event archive.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
     */
    public val eventPattern: Output<String>?
        get() = javaResource.eventPattern().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Event bus source ARN from where these events should be archived.
     */
    public val eventSourceArn: Output<String>
        get() = javaResource.eventSourceArn().applyValue({ args0 -> args0 })

    /**
     * The name of the new event archive. The archive name cannot exceed 48 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
     */
    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object EventArchiveMapper : ResourceMapper<EventArchive> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventArchive::class == javaResource::class

    override fun map(javaResource: Resource): EventArchive = EventArchive(
        javaResource as
            com.pulumi.aws.cloudwatch.EventArchive,
    )
}

/**
 * @see [EventArchive].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventArchive].
 */
public suspend fun eventArchive(
    name: String,
    block: suspend EventArchiveResourceBuilder.() -> Unit,
): EventArchive {
    val builder = EventArchiveResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventArchive].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventArchive(name: String): EventArchive {
    val builder = EventArchiveResourceBuilder()
    builder.name(name)
    return builder.build()
}
