@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventArchiveArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge event archive resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.cloudwatch.EventArchive;
 * import com.pulumi.aws.cloudwatch.EventArchiveArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderEventBus = new EventBus("orderEventBus");
 *         var orderEventArchive = new EventArchive("orderEventArchive", EventArchiveArgs.builder()
 *             .eventSourceArn(orderEventBus.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Example all optional arguments
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const orderEventBus = new aws.cloudwatch.EventBus("orderEventBus", {});
 * const orderEventArchive = new aws.cloudwatch.EventArchive("orderEventArchive", {
 *     description: "Archived events from order service",
 *     eventSourceArn: orderEventBus.arn,
 *     retentionDays: 7,
 *     eventPattern: JSON.stringify({
 *         source: ["company&#46;team&#46;order"],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * order_event_bus = aws.cloudwatch.EventBus("orderEventBus")
 * order_event_archive = aws.cloudwatch.EventArchive("orderEventArchive",
 *     description="Archived events from order service",
 *     event_source_arn=order_event_bus.arn,
 *     retention_days=7,
 *     event_pattern=json.dumps({
 *         "source": ["company&#46;team&#46;order"],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderEventBus = new Aws.CloudWatch.EventBus("orderEventBus");
 *     var orderEventArchive = new Aws.CloudWatch.EventArchive("orderEventArchive", new()
 *     {
 *         Description = "Archived events from order service",
 *         EventSourceArn = orderEventBus.Arn,
 *         RetentionDays = 7,
 *         EventPattern = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["source"] = new[]
 *             {
 *                 "company.team.order",
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		orderEventBus, err := cloudwatch.NewEventBus(ctx, "orderEventBus", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"source": []string{
 * 				"company.team.order",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = cloudwatch.NewEventArchive(ctx, "orderEventArchive", &cloudwatch.EventArchiveArgs{
 * 			Description:    pulumi.String("Archived events from order service"),
 * 			EventSourceArn: orderEventBus.Arn,
 * 			RetentionDays:  pulumi.Int(7),
 * 			EventPattern:   pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.cloudwatch.EventArchive;
 * import com.pulumi.aws.cloudwatch.EventArchiveArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderEventBus = new EventBus("orderEventBus");
 *         var orderEventArchive = new EventArchive("orderEventArchive", EventArchiveArgs.builder()
 *             .description("Archived events from order service")
 *             .eventSourceArn(orderEventBus.arn())
 *             .retentionDays(7)
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("source", jsonArray("company.team.order"))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   orderEventBus:
 *     type: aws:cloudwatch:EventBus
 *   orderEventArchive:
 *     type: aws:cloudwatch:EventArchive
 *     properties:
 *       description: Archived events from order service
 *       eventSourceArn: ${orderEventBus.arn}
 *       retentionDays: 7
 *       eventPattern:
 *         fn::toJSON:
 *           source:
 *             - company.team.order
 * ```
 * ## Import
 * Using `pulumi import`, import an EventBridge archive using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventArchive:EventArchive imported_event_archive order-archive
 * ```
 * @property description The description of the new event archive.
 * @property eventPattern Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
 * @property eventSourceArn Event bus source ARN from where these events should be archived.
 * @property name The name of the new event archive. The archive name cannot exceed 48 characters.
 * @property retentionDays The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
 */
public data class EventArchiveArgs(
    public val description: Output<String>? = null,
    public val eventPattern: Output<String>? = null,
    public val eventSourceArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventArchiveArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventArchiveArgs =
        com.pulumi.aws.cloudwatch.EventArchiveArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventPattern(eventPattern?.applyValue({ args0 -> args0 }))
            .eventSourceArn(eventSourceArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventArchiveArgs].
 */
@PulumiTagMarker
public class EventArchiveArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventPattern: Output<String>? = null

    private var eventSourceArn: Output<String>? = null

    private var name: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    /**
     * @param value The description of the new event archive.
     */
    @JvmName("mwnqglofxkhaallk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
     */
    @JvmName("fqqnbmhysqwrkntm")
    public suspend fun eventPattern(`value`: Output<String>) {
        this.eventPattern = value
    }

    /**
     * @param value Event bus source ARN from where these events should be archived.
     */
    @JvmName("wunnikfoprieusgu")
    public suspend fun eventSourceArn(`value`: Output<String>) {
        this.eventSourceArn = value
    }

    /**
     * @param value The name of the new event archive. The archive name cannot exceed 48 characters.
     */
    @JvmName("jcerxjgixbrdywvn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
     */
    @JvmName("uykjmvkficitsmbj")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The description of the new event archive.
     */
    @JvmName("nclxbqnfhqgctyyd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
     */
    @JvmName("sqlplobjptuifdud")
    public suspend fun eventPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventPattern = mapped
    }

    /**
     * @param value Event bus source ARN from where these events should be archived.
     */
    @JvmName("fncnqgrfgmwttfhe")
    public suspend fun eventSourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSourceArn = mapped
    }

    /**
     * @param value The name of the new event archive. The archive name cannot exceed 48 characters.
     */
    @JvmName("jcafncnapydbhubx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
     */
    @JvmName("jfeuhasnalobryvd")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    internal fun build(): EventArchiveArgs = EventArchiveArgs(
        description = description,
        eventPattern = eventPattern,
        eventSourceArn = eventSourceArn,
        name = name,
        retentionDays = retentionDays,
    )
}
