@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EventBus].
 */
@PulumiTagMarker
public class EventBusResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventBusArgs = EventBusArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventBusArgsBuilder.() -> Unit) {
        val builder = EventBusArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventBus {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventBus(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventBus(builtJavaResource)
    }
}

/**
 * Provides an EventBridge event bus resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var messenger = new EventBus("messenger");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge event buses using the `name` (which can also be a partner event source name). For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventBus:EventBus messenger chat-messages
 * ```
 *
 */
public class EventBus internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventBus,
) : KotlinCustomResource(javaResource, EventBusMapper) {
    /**
     * The Amazon Resource Name (ARN) of the event bus.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The partner event source that the new event bus will be matched with. Must match `name`.
     */
    public val eventSourceName: Output<String>?
        get() = javaResource.eventSourceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the new event bus. The names of custom event buses can't contain the / character. To create a partner event bus, ensure the `name` matches the `event_source_name`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EventBusMapper : ResourceMapper<EventBus> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventBus::class == javaResource::class

    override fun map(javaResource: Resource): EventBus = EventBus(
        javaResource as
            com.pulumi.aws.cloudwatch.EventBus,
    )
}

/**
 * @see [EventBus].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventBus].
 */
public suspend fun eventBus(name: String, block: suspend EventBusResourceBuilder.() -> Unit):
    EventBus {
    val builder = EventBusResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventBus].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventBus(name: String): EventBus {
    val builder = EventBusResourceBuilder()
    builder.name(name)
    return builder.build()
}
