@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventBusPolicy].
 */
@PulumiTagMarker
public class EventBusPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventBusPolicyArgs = EventBusPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventBusPolicyArgsBuilder.() -> Unit) {
        val builder = EventBusPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventBusPolicy {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventBusPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventBusPolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to create an EventBridge resource policy to support cross-account events.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * > **Note:** The EventBridge bus policy resource  (`aws.cloudwatch.EventBusPolicy`) is incompatible with the EventBridge permission resource (`aws.cloudwatch.EventPermission`) and will overwrite permissions.
 * ## Example Usage
 * ### Account Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("DevAccountAccess")
 *                 .effect("Allow")
 *                 .actions("events:PutEvents")
 *                 .resources("arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(aws_cloudwatch_event_bus.test().name())
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("OrganizationAccess")
 *                 .effect("Allow")
 *                 .actions(
 *                     "events:DescribeRule",
 *                     "events:ListRules",
 *                     "events:ListTargetsByRule",
 *                     "events:ListTagsForResource")
 *                 .resources(
 *                     "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("StringEquals")
 *                     .variable("aws:PrincipalOrgID")
 *                     .values(aws_organizations_organization.example().id())
 *                     .build())
 *                 .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(aws_cloudwatch_event_bus.test().name())
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple Statements
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("DevAccountAccess")
 *                     .effect("Allow")
 *                     .actions("events:PutEvents")
 *                     .resources("arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("123456789012")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("OrganizationAccess")
 *                     .effect("Allow")
 *                     .actions(
 *                         "events:DescribeRule",
 *                         "events:ListRules",
 *                         "events:ListTargetsByRule",
 *                         "events:ListTagsForResource")
 *                     .resources(
 *                         "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                         "arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("*")
 *                         .build())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("aws:PrincipalOrgID")
 *                         .values(aws_organizations_organization.example().id())
 *                         .build())
 *                     .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(aws_cloudwatch_event_bus.test().name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an EventBridge policy using the `event_bus_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventBusPolicy:EventBusPolicy DevAccountAccess example-event-bus
 * ```
 * */*/
 */
public class EventBusPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventBusPolicy,
) : KotlinCustomResource(javaResource, EventBusPolicyMapper) {
    /**
     * The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    public val eventBusName: Output<String>?
        get() = javaResource.eventBusName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The text of the policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object EventBusPolicyMapper : ResourceMapper<EventBusPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventBusPolicy::class == javaResource::class

    override fun map(javaResource: Resource): EventBusPolicy = EventBusPolicy(
        javaResource as
            com.pulumi.aws.cloudwatch.EventBusPolicy,
    )
}

/**
 * @see [EventBusPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventBusPolicy].
 */
public suspend fun eventBusPolicy(
    name: String,
    block: suspend EventBusPolicyResourceBuilder.() -> Unit,
): EventBusPolicy {
    val builder = EventBusPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventBusPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventBusPolicy(name: String): EventBusPolicy {
    val builder = EventBusPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
