@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventBusPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an EventBridge resource policy to support cross-account events.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * > **Note:** The EventBridge bus policy resource  (`aws.cloudwatch.EventBusPolicy`) is incompatible with the EventBridge permission resource (`aws.cloudwatch.EventPermission`) and will overwrite permissions.
 * ## Example Usage
 * ### Account Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("DevAccountAccess")
 *                 .effect("Allow")
 *                 .actions("events:PutEvents")
 *                 .resources("arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(aws_cloudwatch_event_bus.test().name())
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("OrganizationAccess")
 *                 .effect("Allow")
 *                 .actions(
 *                     "events:DescribeRule",
 *                     "events:ListRules",
 *                     "events:ListTargetsByRule",
 *                     "events:ListTagsForResource")
 *                 .resources(
 *                     "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                     "arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("StringEquals")
 *                     .variable("aws:PrincipalOrgID")
 *                     .values(aws_organizations_organization.example().id())
 *                     .build())
 *                 .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(aws_cloudwatch_event_bus.test().name())
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple Statements
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.EventBusPolicy;
 * import com.pulumi.aws.cloudwatch.EventBusPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("DevAccountAccess")
 *                     .effect("Allow")
 *                     .actions("events:PutEvents")
 *                     .resources("arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("123456789012")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("OrganizationAccess")
 *                     .effect("Allow")
 *                     .actions(
 *                         "events:DescribeRule",
 *                         "events:ListRules",
 *                         "events:ListTargetsByRule",
 *                         "events:ListTagsForResource")
 *                     .resources(
 *                         "arn:aws:events:eu-west-1:123456789012:rule/*",
 *                         "arn:aws:events:eu-west-1:123456789012:event-bus/default")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers("*")
 *                         .build())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("aws:PrincipalOrgID")
 *                         .values(aws_organizations_organization.example().id())
 *                         .build())
 *                     .build())
 *             .build());
 *         var testEventBusPolicy = new EventBusPolicy("testEventBusPolicy", EventBusPolicyArgs.builder()
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .eventBusName(aws_cloudwatch_event_bus.test().name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an EventBridge policy using the `event_bus_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventBusPolicy:EventBusPolicy DevAccountAccess example-event-bus
 * ```
 * @property eventBusName The name of the event bus to set the permissions on.
 * If you omit this, the permissions are set on the `default` event bus.
 * @property policy The text of the policy.
 * */*/
 */
public data class EventBusPolicyArgs(
    public val eventBusName: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventBusPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventBusPolicyArgs =
        com.pulumi.aws.cloudwatch.EventBusPolicyArgs.builder()
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventBusPolicyArgs].
 */
@PulumiTagMarker
public class EventBusPolicyArgsBuilder internal constructor() {
    private var eventBusName: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    @JvmName("kpbcbneqssdvleib")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The text of the policy.
     */
    @JvmName("kdrvqolpnyueeakr")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    @JvmName("vcoajqprptldjvft")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value The text of the policy.
     */
    @JvmName("eylkdamneqetgqsb")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): EventBusPolicyArgs = EventBusPolicyArgs(
        eventBusName = eventBusName,
        policy = policy,
    )
}
