@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParameters
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParameters.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventConnection].
 */
@PulumiTagMarker
public class EventConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventConnectionArgs = EventConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventConnectionArgsBuilder.() -> Unit) {
        val builder = EventConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventConnection {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventConnection(builtJavaResource)
    }
}

/**
 * Provides an EventBridge connection resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .apiKey(EventConnectionAuthParametersApiKeyArgs.builder()
 *                     .key("x-signature")
 *                     .value("1234")
 *                     .build())
 *                 .build())
 *             .authorizationType("API_KEY")
 *             .description("A connection description")
 *             .build());
 *     }
 * }
 * ```
 * ### Basic Authorization
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .basic(EventConnectionAuthParametersBasicArgs.builder()
 *                     .password("Pass1234!")
 *                     .username("user")
 *                     .build())
 *                 .build())
 *             .authorizationType("BASIC")
 *             .description("A connection description")
 *             .build());
 *     }
 * }
 * ```
 * ### OAuth Authorization
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthClientParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .oauth(EventConnectionAuthParametersOauthArgs.builder()
 *                     .authorizationEndpoint("https://auth.url.com/endpoint")
 *                     .clientParameters(EventConnectionAuthParametersOauthClientParametersArgs.builder()
 *                         .clientId("1234567890")
 *                         .clientSecret("Pass1234!")
 *                         .build())
 *                     .httpMethod("GET")
 *                     .oauthHttpParameters(EventConnectionAuthParametersOauthOauthHttpParametersArgs.builder()
 *                         .body(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .header(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .queryString(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .authorizationType("OAUTH_CLIENT_CREDENTIALS")
 *             .description("A connection description")
 *             .build());
 *     }
 * }
 * ```
 * ### Invocation Http Parameters
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .basic(EventConnectionAuthParametersBasicArgs.builder()
 *                     .password("Pass1234!")
 *                     .username("user")
 *                     .build())
 *                 .invocationHttpParameters(EventConnectionAuthParametersInvocationHttpParametersArgs.builder()
 *                     .body(
 *                         %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference),
 *                         %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .header(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .queryString(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .build())
 *             .authorizationType("BASIC")
 *             .description("A connection description")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge EventBridge connection using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventConnection:EventConnection test ngrok-connection
 * ```
 *
 */
public class EventConnection internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventConnection,
) : KotlinCustomResource(javaResource, EventConnectionMapper) {
    /**
     * The Amazon Resource Name (ARN) of the connection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Parameters used for authorization. A maximum of 1 are allowed. Documented below.
     */
    public val authParameters: Output<EventConnectionAuthParameters>
        get() = javaResource.authParameters().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Choose the type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
     */
    public val authorizationType: Output<String>
        get() = javaResource.authorizationType().applyValue({ args0 -> args0 })

    /**
     * Enter a description for the connection. Maximum of 512 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the new connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the secret created from the authorization parameters specified for the connection.
     */
    public val secretArn: Output<String>
        get() = javaResource.secretArn().applyValue({ args0 -> args0 })
}

public object EventConnectionMapper : ResourceMapper<EventConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventConnection::class == javaResource::class

    override fun map(javaResource: Resource): EventConnection = EventConnection(
        javaResource as
            com.pulumi.aws.cloudwatch.EventConnection,
    )
}

/**
 * @see [EventConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventConnection].
 */
public suspend fun eventConnection(
    name: String,
    block: suspend EventConnectionResourceBuilder.() -> Unit,
): EventConnection {
    val builder = EventConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventConnection(name: String): EventConnection {
    val builder = EventConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
