@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventConnectionArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventConnectionAuthParametersArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventConnectionAuthParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge connection resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .apiKey(EventConnectionAuthParametersApiKeyArgs.builder()
 *                     .key("x-signature")
 *                     .value("1234")
 *                     .build())
 *                 .build())
 *             .authorizationType("API_KEY")
 *             .description("A connection description")
 *             .build());
 *     }
 * }
 * ```
 * ### Basic Authorization
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .basic(EventConnectionAuthParametersBasicArgs.builder()
 *                     .password("Pass1234!")
 *                     .username("user")
 *                     .build())
 *                 .build())
 *             .authorizationType("BASIC")
 *             .description("A connection description")
 *             .build());
 *     }
 * }
 * ```
 * ### OAuth Authorization
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthClientParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .oauth(EventConnectionAuthParametersOauthArgs.builder()
 *                     .authorizationEndpoint("https://auth.url.com/endpoint")
 *                     .clientParameters(EventConnectionAuthParametersOauthClientParametersArgs.builder()
 *                         .clientId("1234567890")
 *                         .clientSecret("Pass1234!")
 *                         .build())
 *                     .httpMethod("GET")
 *                     .oauthHttpParameters(EventConnectionAuthParametersOauthOauthHttpParametersArgs.builder()
 *                         .body(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .header(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .queryString(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .authorizationType("OAUTH_CLIENT_CREDENTIALS")
 *             .description("A connection description")
 *             .build());
 *     }
 * }
 * ```
 * ### Invocation Http Parameters
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventConnection;
 * import com.pulumi.aws.cloudwatch.EventConnectionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersBasicArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new EventConnection("test", EventConnectionArgs.builder()
 *             .authParameters(EventConnectionAuthParametersArgs.builder()
 *                 .basic(EventConnectionAuthParametersBasicArgs.builder()
 *                     .password("Pass1234!")
 *                     .username("user")
 *                     .build())
 *                 .invocationHttpParameters(EventConnectionAuthParametersInvocationHttpParametersArgs.builder()
 *                     .body(
 *                         %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference),
 *                         %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .header(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .queryString(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .build())
 *             .authorizationType("BASIC")
 *             .description("A connection description")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge EventBridge connection using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventConnection:EventConnection test ngrok-connection
 * ```
 * @property authParameters Parameters used for authorization. A maximum of 1 are allowed. Documented below.
 * @property authorizationType Choose the type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
 * @property description Enter a description for the connection. Maximum of 512 characters.
 * @property name The name of the new connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
 */
public data class EventConnectionArgs(
    public val authParameters: Output<EventConnectionAuthParametersArgs>? = null,
    public val authorizationType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventConnectionArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventConnectionArgs =
        com.pulumi.aws.cloudwatch.EventConnectionArgs.builder()
            .authParameters(authParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .authorizationType(authorizationType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventConnectionArgs].
 */
@PulumiTagMarker
public class EventConnectionArgsBuilder internal constructor() {
    private var authParameters: Output<EventConnectionAuthParametersArgs>? = null

    private var authorizationType: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Parameters used for authorization. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("gtlxmycraumhwenw")
    public suspend fun authParameters(`value`: Output<EventConnectionAuthParametersArgs>) {
        this.authParameters = value
    }

    /**
     * @param value Choose the type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
     */
    @JvmName("mrkbjdoxismslvww")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value Enter a description for the connection. Maximum of 512 characters.
     */
    @JvmName("kkytjehqimsqesun")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the new connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    @JvmName("dlahklcukdsmsxhr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parameters used for authorization. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("rsvcgyyiogwghoqi")
    public suspend fun authParameters(`value`: EventConnectionAuthParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authParameters = mapped
    }

    /**
     * @param argument Parameters used for authorization. A maximum of 1 are allowed. Documented below.
     */
    @JvmName("jcwkrqcuuhxrpxai")
    public suspend
    fun authParameters(argument: suspend EventConnectionAuthParametersArgsBuilder.() -> Unit) {
        val toBeMapped = EventConnectionAuthParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authParameters = mapped
    }

    /**
     * @param value Choose the type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
     */
    @JvmName("wcwoyaurpsyxwhkb")
    public suspend fun authorizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value Enter a description for the connection. Maximum of 512 characters.
     */
    @JvmName("kdrvdqnytktwjyoc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the new connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
     */
    @JvmName("eitbimmjhbvxalle")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EventConnectionArgs = EventConnectionArgs(
        authParameters = authParameters,
        authorizationType = authorizationType,
        description = description,
        name = name,
    )
}
