@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.EventEndpointEventBus
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventEndpointReplicationConfig
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventEndpointRoutingConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventEndpointEventBus.Companion.toKotlin as eventEndpointEventBusToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventEndpointReplicationConfig.Companion.toKotlin as eventEndpointReplicationConfigToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventEndpointRoutingConfig.Companion.toKotlin as eventEndpointRoutingConfigToKotlin

/**
 * Builder for [EventEndpoint].
 */
@PulumiTagMarker
public class EventEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventEndpointArgs = EventEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventEndpointArgsBuilder.() -> Unit) {
        val builder = EventEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventEndpoint {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventEndpoint(builtJavaResource)
    }
}

/**
 * Provides a resource to create an EventBridge Global Endpoint.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventEndpoint;
 * import com.pulumi.aws.cloudwatch.EventEndpointArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointEventBusArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointReplicationConfigArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigPrimaryArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigSecondaryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new EventEndpoint("this", EventEndpointArgs.builder()
 *             .roleArn(aws_iam_role.replication().arn())
 *             .eventBuses(
 *                 EventEndpointEventBusArgs.builder()
 *                     .eventBusArn(aws_cloudwatch_event_bus.primary().arn())
 *                     .build(),
 *                 EventEndpointEventBusArgs.builder()
 *                     .eventBusArn(aws_cloudwatch_event_bus.secondary().arn())
 *                     .build())
 *             .replicationConfig(EventEndpointReplicationConfigArgs.builder()
 *                 .state("DISABLED")
 *                 .build())
 *             .routingConfig(EventEndpointRoutingConfigArgs.builder()
 *                 .failoverConfig(EventEndpointRoutingConfigFailoverConfigArgs.builder()
 *                     .primary(EventEndpointRoutingConfigFailoverConfigPrimaryArgs.builder()
 *                         .healthCheck(aws_route53_health_check.primary().arn())
 *                         .build())
 *                     .secondary(EventEndpointRoutingConfigFailoverConfigSecondaryArgs.builder()
 *                         .route("us-east-2")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge Global Endpoints using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventEndpoint:EventEndpoint imported_endpoint example-endpoint
 * ```
 *
 */
public class EventEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventEndpoint,
) : KotlinCustomResource(javaResource, EventEndpointMapper) {
    /**
     * The ARN of the endpoint that was created.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the global endpoint.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL of the endpoint that was created.
     */
    public val endpointUrl: Output<String>
        get() = javaResource.endpointUrl().applyValue({ args0 -> args0 })

    /**
     * The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
     */
    public val eventBuses: Output<List<EventEndpointEventBus>>
        get() = javaResource.eventBuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventEndpointEventBusToKotlin(args0)
                })
            })
        })

    /**
     * The name of the global endpoint.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Parameters used for replication. Documented below.
     */
    public val replicationConfig: Output<EventEndpointReplicationConfig>?
        get() = javaResource.replicationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventEndpointReplicationConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ARN of the IAM role used for replication between event buses.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Parameters used for routing, including the health check and secondary Region. Documented below.
     */
    public val routingConfig: Output<EventEndpointRoutingConfig>
        get() = javaResource.routingConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                eventEndpointRoutingConfigToKotlin(args0)
            })
        })
}

public object EventEndpointMapper : ResourceMapper<EventEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): EventEndpoint = EventEndpoint(
        javaResource as
            com.pulumi.aws.cloudwatch.EventEndpoint,
    )
}

/**
 * @see [EventEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventEndpoint].
 */
public suspend fun eventEndpoint(
    name: String,
    block: suspend EventEndpointResourceBuilder.() -> Unit,
): EventEndpoint {
    val builder = EventEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventEndpoint(name: String): EventEndpoint {
    val builder = EventEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
