@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventEndpointArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventEndpointEventBusArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventEndpointEventBusArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventEndpointReplicationConfigArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventEndpointReplicationConfigArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventEndpointRoutingConfigArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventEndpointRoutingConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an EventBridge Global Endpoint.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventEndpoint;
 * import com.pulumi.aws.cloudwatch.EventEndpointArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointEventBusArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointReplicationConfigArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigPrimaryArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigFailoverConfigSecondaryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new EventEndpoint("this", EventEndpointArgs.builder()
 *             .roleArn(aws_iam_role.replication().arn())
 *             .eventBuses(
 *                 EventEndpointEventBusArgs.builder()
 *                     .eventBusArn(aws_cloudwatch_event_bus.primary().arn())
 *                     .build(),
 *                 EventEndpointEventBusArgs.builder()
 *                     .eventBusArn(aws_cloudwatch_event_bus.secondary().arn())
 *                     .build())
 *             .replicationConfig(EventEndpointReplicationConfigArgs.builder()
 *                 .state("DISABLED")
 *                 .build())
 *             .routingConfig(EventEndpointRoutingConfigArgs.builder()
 *                 .failoverConfig(EventEndpointRoutingConfigFailoverConfigArgs.builder()
 *                     .primary(EventEndpointRoutingConfigFailoverConfigPrimaryArgs.builder()
 *                         .healthCheck(aws_route53_health_check.primary().arn())
 *                         .build())
 *                     .secondary(EventEndpointRoutingConfigFailoverConfigSecondaryArgs.builder()
 *                         .route("us-east-2")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge Global Endpoints using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventEndpoint:EventEndpoint imported_endpoint example-endpoint
 * ```
 * @property description A description of the global endpoint.
 * @property eventBuses The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
 * @property name The name of the global endpoint.
 * @property replicationConfig Parameters used for replication. Documented below.
 * @property roleArn The ARN of the IAM role used for replication between event buses.
 * @property routingConfig Parameters used for routing, including the health check and secondary Region. Documented below.
 */
public data class EventEndpointArgs(
    public val description: Output<String>? = null,
    public val eventBuses: Output<List<EventEndpointEventBusArgs>>? = null,
    public val name: Output<String>? = null,
    public val replicationConfig: Output<EventEndpointReplicationConfigArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val routingConfig: Output<EventEndpointRoutingConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventEndpointArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventEndpointArgs =
        com.pulumi.aws.cloudwatch.EventEndpointArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventBuses(
                eventBuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .replicationConfig(replicationConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .routingConfig(routingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EventEndpointArgs].
 */
@PulumiTagMarker
public class EventEndpointArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventBuses: Output<List<EventEndpointEventBusArgs>>? = null

    private var name: Output<String>? = null

    private var replicationConfig: Output<EventEndpointReplicationConfigArgs>? = null

    private var roleArn: Output<String>? = null

    private var routingConfig: Output<EventEndpointRoutingConfigArgs>? = null

    /**
     * @param value A description of the global endpoint.
     */
    @JvmName("eyeykasrtjrvkfsm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
     */
    @JvmName("cgnkabhpjkjopiqp")
    public suspend fun eventBuses(`value`: Output<List<EventEndpointEventBusArgs>>) {
        this.eventBuses = value
    }

    @JvmName("qvjhkswylukffxys")
    public suspend fun eventBuses(vararg values: Output<EventEndpointEventBusArgs>) {
        this.eventBuses = Output.all(values.asList())
    }

    /**
     * @param values The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
     */
    @JvmName("nsiuxbjbavwargvx")
    public suspend fun eventBuses(values: List<Output<EventEndpointEventBusArgs>>) {
        this.eventBuses = Output.all(values)
    }

    /**
     * @param value The name of the global endpoint.
     */
    @JvmName("lcjwkqjqqprcojjq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parameters used for replication. Documented below.
     */
    @JvmName("hsimusvttipewtas")
    public suspend fun replicationConfig(`value`: Output<EventEndpointReplicationConfigArgs>) {
        this.replicationConfig = value
    }

    /**
     * @param value The ARN of the IAM role used for replication between event buses.
     */
    @JvmName("sibfqanrgilrelik")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Parameters used for routing, including the health check and secondary Region. Documented below.
     */
    @JvmName("lyxyvihwoabshjbb")
    public suspend fun routingConfig(`value`: Output<EventEndpointRoutingConfigArgs>) {
        this.routingConfig = value
    }

    /**
     * @param value A description of the global endpoint.
     */
    @JvmName("saiokeklfscqovdp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
     */
    @JvmName("tsaaaeldvexpdtwg")
    public suspend fun eventBuses(`value`: List<EventEndpointEventBusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBuses = mapped
    }

    /**
     * @param argument The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
     */
    @JvmName("sriyjabkfaxtdail")
    public suspend
    fun eventBuses(argument: List<suspend EventEndpointEventBusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventEndpointEventBusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventBuses = mapped
    }

    /**
     * @param argument The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
     */
    @JvmName("lerqlfkdqsbnddgr")
    public suspend fun eventBuses(
        vararg
        argument: suspend EventEndpointEventBusArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventEndpointEventBusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventBuses = mapped
    }

    /**
     * @param argument The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
     */
    @JvmName("ayqacmgkfooqjroq")
    public suspend fun eventBuses(argument: suspend EventEndpointEventBusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventEndpointEventBusArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eventBuses = mapped
    }

    /**
     * @param values The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
     */
    @JvmName("recjyyxviausmixl")
    public suspend fun eventBuses(vararg values: EventEndpointEventBusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventBuses = mapped
    }

    /**
     * @param value The name of the global endpoint.
     */
    @JvmName("yylanmhmiclcffhk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Parameters used for replication. Documented below.
     */
    @JvmName("cjtnrqcmllxfxkdj")
    public suspend fun replicationConfig(`value`: EventEndpointReplicationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationConfig = mapped
    }

    /**
     * @param argument Parameters used for replication. Documented below.
     */
    @JvmName("qwqemscajnbkkina")
    public suspend
    fun replicationConfig(argument: suspend EventEndpointReplicationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EventEndpointReplicationConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.replicationConfig = mapped
    }

    /**
     * @param value The ARN of the IAM role used for replication between event buses.
     */
    @JvmName("grhjhplctadtlpxo")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Parameters used for routing, including the health check and secondary Region. Documented below.
     */
    @JvmName("paaddcjnriuwadsi")
    public suspend fun routingConfig(`value`: EventEndpointRoutingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfig = mapped
    }

    /**
     * @param argument Parameters used for routing, including the health check and secondary Region. Documented below.
     */
    @JvmName("irnjpdksyuluxkud")
    public suspend
    fun routingConfig(argument: suspend EventEndpointRoutingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EventEndpointRoutingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfig = mapped
    }

    internal fun build(): EventEndpointArgs = EventEndpointArgs(
        description = description,
        eventBuses = eventBuses,
        name = name,
        replicationConfig = replicationConfig,
        roleArn = roleArn,
        routingConfig = routingConfig,
    )
}
