@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.EventPermissionCondition
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventPermissionCondition.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventPermission].
 */
@PulumiTagMarker
public class EventPermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventPermissionArgs = EventPermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventPermissionArgsBuilder.() -> Unit) {
        val builder = EventPermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventPermission {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventPermission(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventPermission(builtJavaResource)
    }
}

/**
 * Provides a resource to create an EventBridge permission to support cross-account events in the current account default event bus.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * > **Note:** The EventBridge bus policy resource  (`aws.cloudwatch.EventBusPolicy`) is incompatible with the EventBridge permission resource (`aws.cloudwatch.EventPermission`) and will overwrite permissions.
 * ## Example Usage
 * ### Account Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventPermission;
 * import com.pulumi.aws.cloudwatch.EventPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devAccountAccess = new EventPermission("devAccountAccess", EventPermissionArgs.builder()
 *             .principal("123456789012")
 *             .statementId("DevAccountAccess")
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventPermission;
 * import com.pulumi.aws.cloudwatch.EventPermissionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventPermissionConditionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var organizationAccess = new EventPermission("organizationAccess", EventPermissionArgs.builder()
 *             .principal("*")
 *             .statementId("OrganizationAccess")
 *             .condition(EventPermissionConditionArgs.builder()
 *                 .key("aws:PrincipalOrgID")
 *                 .type("StringEquals")
 *                 .value(aws_organizations_organization.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge permissions using the `event_bus_name/statement_id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventPermission:EventPermission DevAccountAccess example-event-bus/DevAccountAccess
 * ```
 *
 */
public class EventPermission internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventPermission,
) : KotlinCustomResource(javaResource, EventPermissionMapper) {
    /**
     * The action that you are enabling the other account to perform. Defaults to `events:PutEvents`.
     */
    public val action: Output<String>?
        get() = javaResource.action().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
     */
    public val condition: Output<EventPermissionCondition>?
        get() = javaResource.condition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    public val eventBusName: Output<String>?
        get() = javaResource.eventBusName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify `*` to permit any account to put events to your default event bus, optionally limited by `condition`.
     */
    public val principal: Output<String>
        get() = javaResource.principal().applyValue({ args0 -> args0 })

    /**
     * An identifier string for the external account that you are granting permissions to.
     */
    public val statementId: Output<String>
        get() = javaResource.statementId().applyValue({ args0 -> args0 })
}

public object EventPermissionMapper : ResourceMapper<EventPermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventPermission::class == javaResource::class

    override fun map(javaResource: Resource): EventPermission = EventPermission(
        javaResource as
            com.pulumi.aws.cloudwatch.EventPermission,
    )
}

/**
 * @see [EventPermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventPermission].
 */
public suspend fun eventPermission(
    name: String,
    block: suspend EventPermissionResourceBuilder.() -> Unit,
): EventPermission {
    val builder = EventPermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventPermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventPermission(name: String): EventPermission {
    val builder = EventPermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
