@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventPermissionArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventPermissionConditionArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventPermissionConditionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an EventBridge permission to support cross-account events in the current account default event bus.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * > **Note:** The EventBridge bus policy resource  (`aws.cloudwatch.EventBusPolicy`) is incompatible with the EventBridge permission resource (`aws.cloudwatch.EventPermission`) and will overwrite permissions.
 * ## Example Usage
 * ### Account Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventPermission;
 * import com.pulumi.aws.cloudwatch.EventPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devAccountAccess = new EventPermission("devAccountAccess", EventPermissionArgs.builder()
 *             .principal("123456789012")
 *             .statementId("DevAccountAccess")
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventPermission;
 * import com.pulumi.aws.cloudwatch.EventPermissionArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventPermissionConditionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var organizationAccess = new EventPermission("organizationAccess", EventPermissionArgs.builder()
 *             .principal("*")
 *             .statementId("OrganizationAccess")
 *             .condition(EventPermissionConditionArgs.builder()
 *                 .key("aws:PrincipalOrgID")
 *                 .type("StringEquals")
 *                 .value(aws_organizations_organization.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge permissions using the `event_bus_name/statement_id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventPermission:EventPermission DevAccountAccess example-event-bus/DevAccountAccess
 * ```
 * @property action The action that you are enabling the other account to perform. Defaults to `events:PutEvents`.
 * @property condition Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
 * @property eventBusName The name of the event bus to set the permissions on.
 * If you omit this, the permissions are set on the `default` event bus.
 * @property principal The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify `*` to permit any account to put events to your default event bus, optionally limited by `condition`.
 * @property statementId An identifier string for the external account that you are granting permissions to.
 */
public data class EventPermissionArgs(
    public val action: Output<String>? = null,
    public val condition: Output<EventPermissionConditionArgs>? = null,
    public val eventBusName: Output<String>? = null,
    public val principal: Output<String>? = null,
    public val statementId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventPermissionArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventPermissionArgs =
        com.pulumi.aws.cloudwatch.EventPermissionArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .condition(condition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0 }))
            .statementId(statementId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventPermissionArgs].
 */
@PulumiTagMarker
public class EventPermissionArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var condition: Output<EventPermissionConditionArgs>? = null

    private var eventBusName: Output<String>? = null

    private var principal: Output<String>? = null

    private var statementId: Output<String>? = null

    /**
     * @param value The action that you are enabling the other account to perform. Defaults to `events:PutEvents`.
     */
    @JvmName("yofcikdlanpyarhc")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
     */
    @JvmName("fwyrpbvcixsqiraq")
    public suspend fun condition(`value`: Output<EventPermissionConditionArgs>) {
        this.condition = value
    }

    /**
     * @param value The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    @JvmName("qquuhrqdeldclpls")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify `*` to permit any account to put events to your default event bus, optionally limited by `condition`.
     */
    @JvmName("aubfuuehwxjdfrpb")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value An identifier string for the external account that you are granting permissions to.
     */
    @JvmName("hmaeohxxjcrriyhm")
    public suspend fun statementId(`value`: Output<String>) {
        this.statementId = value
    }

    /**
     * @param value The action that you are enabling the other account to perform. Defaults to `events:PutEvents`.
     */
    @JvmName("kukrspbphymrwamq")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
     */
    @JvmName("itfgqstyvpsyktgh")
    public suspend fun condition(`value`: EventPermissionConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument Configuration block to limit the event bus permissions you are granting to only accounts that fulfill the condition. Specified below.
     */
    @JvmName("fxoysednloyvimhy")
    public suspend fun condition(argument: suspend EventPermissionConditionArgsBuilder.() -> Unit) {
        val toBeMapped = EventPermissionConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value The name of the event bus to set the permissions on.
     * If you omit this, the permissions are set on the `default` event bus.
     */
    @JvmName("mtcynvpqtmkvcioj")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify `*` to permit any account to put events to your default event bus, optionally limited by `condition`.
     */
    @JvmName("afmdufsxexlmwclc")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value An identifier string for the external account that you are granting permissions to.
     */
    @JvmName("wigiprgsendejall")
    public suspend fun statementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementId = mapped
    }

    internal fun build(): EventPermissionArgs = EventPermissionArgs(
        action = action,
        condition = condition,
        eventBusName = eventBusName,
        principal = principal,
        statementId = statementId,
    )
}
