@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Rule resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var console = new EventRule("console", EventRuleArgs.builder()
 *             .description("Capture each AWS Console Sign In")
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("detail-type", jsonArray("AWS Console Sign In via CloudTrail"))
 *                 )))
 *             .build());
 *         var awsLogins = new Topic("awsLogins");
 *         var sns = new EventTarget("sns", EventTargetArgs.builder()
 *             .rule(console.name())
 *             .arn(awsLogins.arn())
 *             .build());
 *         final var snsTopicPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("SNS:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .resources(awsLogins.arn())
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(awsLogins.arn())
 *             .policy(snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(snsTopicPolicy -> snsTopicPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge Rules using the `event_bus_name/rule_name` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventRule:EventRule console example-event-bus/capture-console-sign-in
 * ```
 * @property description The description of the rule.
 * @property eventBusName The name or ARN of the event bus to associate with this rule.
 * If you omit this, the `default` event bus is used.
 * @property eventPattern The event pattern described a JSON object. At least one of `schedule_expression` or `event_pattern` is required. See full documentation of [Events and Event Patterns in EventBridge](https://docs&#46;aws&#46;amazon&#46;com/eventbridge/latest/userguide/eventbridge-and-event-patterns&#46;html) for details&#46; **Note**: The event pattern size is 2048 by default but it is adjustable up to 4096 characters by submitting a service quota increase request&#46; See [Amazon EventBridge quotas](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-quota.html) for details.
 * @property isEnabled Whether the rule should be enabled.
 * Defaults to `true`.
 * Conflicts with `state`.
 * @property name The name of the rule. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`. **Note**: Due to the length of the generated suffix, must be 38 characters or less.
 * @property roleArn The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
 * @property scheduleExpression The scheduling expression. For example, `cron(0 20 * * ? *)` or `rate(5 minutes)`. At least one of `schedule_expression` or `event_pattern` is required. Can only be used on the default event bus. For more information, refer to the AWS documentation [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
 * @property state State of the rule.
 * Valid values are `DISABLED`, `ENABLED`, and `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
 * When state is `ENABLED`, the rule is enabled for all events except those delivered by CloudTrail.
 * To also enable the rule for events delivered by CloudTrail, set `state` to `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
 * Defaults to `ENABLED`.
 * Conflicts with `is_enabled`.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventRuleArgs(
    public val description: Output<String>? = null,
    public val eventBusName: Output<String>? = null,
    public val eventPattern: Output<String>? = null,
    @Deprecated(
        message = """
  Use "state" instead
  """,
    )
    public val isEnabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val scheduleExpression: Output<String>? = null,
    public val state: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventRuleArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventRuleArgs =
        com.pulumi.aws.cloudwatch.EventRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .eventPattern(eventPattern?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .scheduleExpression(scheduleExpression?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventRuleArgs].
 */
@PulumiTagMarker
public class EventRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventBusName: Output<String>? = null

    private var eventPattern: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var scheduleExpression: Output<String>? = null

    private var state: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the rule.
     */
    @JvmName("turqjgmpgvkfygsr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name or ARN of the event bus to associate with this rule.
     * If you omit this, the `default` event bus is used.
     */
    @JvmName("pscfnfllysemibqc")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value The event pattern described a JSON object. At least one of `schedule_expression` or `event_pattern` is required. See full documentation of [Events and Event Patterns in EventBridge](https://docs&#46;aws&#46;amazon&#46;com/eventbridge/latest/userguide/eventbridge-and-event-patterns&#46;html) for details&#46; **Note**: The event pattern size is 2048 by default but it is adjustable up to 4096 characters by submitting a service quota increase request&#46; See [Amazon EventBridge quotas](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-quota.html) for details.
     */
    @JvmName("jqlxwfhurwqmnjug")
    public suspend fun eventPattern(`value`: Output<String>) {
        this.eventPattern = value
    }

    /**
     * @param value Whether the rule should be enabled.
     * Defaults to `true`.
     * Conflicts with `state`.
     */
    @Deprecated(
        message = """
  Use "state" instead
  """,
    )
    @JvmName("gknlfawvcfcqrrbk")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The name of the rule. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("hefxscanvfcqfeqr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. **Note**: Due to the length of the generated suffix, must be 38 characters or less.
     */
    @JvmName("lkveqtiiuadhkoiu")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
     */
    @JvmName("jyhwsstgosfxdutk")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The scheduling expression. For example, `cron(0 20 * * ? *)` or `rate(5 minutes)`. At least one of `schedule_expression` or `event_pattern` is required. Can only be used on the default event bus. For more information, refer to the AWS documentation [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
     */
    @JvmName("jvxcbtrcbgwpwmgr")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value State of the rule.
     * Valid values are `DISABLED`, `ENABLED`, and `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
     * When state is `ENABLED`, the rule is enabled for all events except those delivered by CloudTrail.
     * To also enable the rule for events delivered by CloudTrail, set `state` to `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
     * Defaults to `ENABLED`.
     * Conflicts with `is_enabled`.
     */
    @JvmName("chaqddvoqciybvcr")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yclvdflasombrgmo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("pfamcychdxhoudst")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name or ARN of the event bus to associate with this rule.
     * If you omit this, the `default` event bus is used.
     */
    @JvmName("tkpvpgskgbcetbnr")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value The event pattern described a JSON object. At least one of `schedule_expression` or `event_pattern` is required. See full documentation of [Events and Event Patterns in EventBridge](https://docs&#46;aws&#46;amazon&#46;com/eventbridge/latest/userguide/eventbridge-and-event-patterns&#46;html) for details&#46; **Note**: The event pattern size is 2048 by default but it is adjustable up to 4096 characters by submitting a service quota increase request&#46; See [Amazon EventBridge quotas](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-quota.html) for details.
     */
    @JvmName("yfyufwhetsgpadjl")
    public suspend fun eventPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventPattern = mapped
    }

    /**
     * @param value Whether the rule should be enabled.
     * Defaults to `true`.
     * Conflicts with `state`.
     */
    @Deprecated(
        message = """
  Use "state" instead
  """,
    )
    @JvmName("otfbvgechxxhloao")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The name of the rule. If omitted, this provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("brubjgridrwtytsy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. **Note**: Due to the length of the generated suffix, must be 38 characters or less.
     */
    @JvmName("nanvyeesnwsuqhoe")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
     */
    @JvmName("gfcrimxlunjfxyed")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The scheduling expression. For example, `cron(0 20 * * ? *)` or `rate(5 minutes)`. At least one of `schedule_expression` or `event_pattern` is required. Can only be used on the default event bus. For more information, refer to the AWS documentation [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
     */
    @JvmName("xtmeepfkgheqnpte")
    public suspend fun scheduleExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    /**
     * @param value State of the rule.
     * Valid values are `DISABLED`, `ENABLED`, and `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
     * When state is `ENABLED`, the rule is enabled for all events except those delivered by CloudTrail.
     * To also enable the rule for events delivered by CloudTrail, set `state` to `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`.
     * Defaults to `ENABLED`.
     * Conflicts with `is_enabled`.
     */
    @JvmName("lgtuhaltwxocimpo")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iyaxmwqwxvdwqebd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ypjuirabcmplfpbe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventRuleArgs = EventRuleArgs(
        description = description,
        eventBusName = eventBusName,
        eventPattern = eventPattern,
        isEnabled = isEnabled,
        name = name,
        namePrefix = namePrefix,
        roleArn = roleArn,
        scheduleExpression = scheduleExpression,
        state = state,
        tags = tags,
    )
}
