@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetBatchTarget
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetDeadLetterConfig
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetEcsTarget
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetHttpTarget
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetInputTransformer
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetKinesisTarget
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetRedshiftTarget
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetRetryPolicy
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetRunCommandTarget
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetSagemakerPipelineTarget
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetSqsTarget
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetBatchTarget.Companion.toKotlin as eventTargetBatchTargetToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetDeadLetterConfig.Companion.toKotlin as eventTargetDeadLetterConfigToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetEcsTarget.Companion.toKotlin as eventTargetEcsTargetToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetHttpTarget.Companion.toKotlin as eventTargetHttpTargetToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetInputTransformer.Companion.toKotlin as eventTargetInputTransformerToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetKinesisTarget.Companion.toKotlin as eventTargetKinesisTargetToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetRedshiftTarget.Companion.toKotlin as eventTargetRedshiftTargetToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetRetryPolicy.Companion.toKotlin as eventTargetRetryPolicyToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetRunCommandTarget.Companion.toKotlin as eventTargetRunCommandTargetToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetSagemakerPipelineTarget.Companion.toKotlin as eventTargetSagemakerPipelineTargetToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetSqsTarget.Companion.toKotlin as eventTargetSqsTargetToKotlin

/**
 * Builder for [EventTarget].
 */
@PulumiTagMarker
public class EventTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventTargetArgs = EventTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventTargetArgsBuilder.() -> Unit) {
        val builder = EventTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventTarget {
        val builtJavaResource = com.pulumi.aws.cloudwatch.EventTarget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventTarget(builtJavaResource)
    }
}

/**
 * Provides an EventBridge Target resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ### Kinesis Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var console = new EventRule("console", EventRuleArgs.builder()
 *             .description("Capture all EC2 scaling events")
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("source", jsonArray("aws.autoscaling")),
 *                     jsonProperty("detail-type", jsonArray(
 *                         "EC2 Instance Launch Successful",
 *                         "EC2 Instance Terminate Successful",
 *                         "EC2 Instance Launch Unsuccessful",
 *                         "EC2 Instance Terminate Unsuccessful"
 *                     ))
 *                 )))
 *             .build());
 *         var testStream = new Stream("testStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var yada = new EventTarget("yada", EventTargetArgs.builder()
 *             .rule(console.name())
 *             .arn(testStream.arn())
 *             .runCommandTargets(
 *                 EventTargetRunCommandTargetArgs.builder()
 *                     .key("tag:Name")
 *                     .values("FooBar")
 *                     .build(),
 *                 EventTargetRunCommandTargetArgs.builder()
 *                     .key("InstanceIds")
 *                     .values("i-162058cd308bffec2")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SSM Document Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ssm.Document;
 * import com.pulumi.aws.ssm.DocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ssmLifecycleTrust = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var stopInstance = new Document("stopInstance", DocumentArgs.builder()
 *             .documentType("Command")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("schemaVersion", "1.2"),
 *                     jsonProperty("description", "Stop an instance"),
 *                     jsonProperty("parameters", jsonObject(
 *                     )),
 *                     jsonProperty("runtimeConfig", jsonObject(
 *                         jsonProperty("aws:runShellScript", jsonObject(
 *                             jsonProperty("properties", jsonArray(jsonObject(
 *                                 jsonProperty("id", "0.aws:runShellScript"),
 *                                 jsonProperty("runCommand", jsonArray("halt"))
 *                             )))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         final var ssmLifecyclePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ssm:SendCommand")
 *                     .resources("arn:aws:ec2:eu-west-1:1234567890:instance/*")
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("ec2:ResourceTag/Terminate")
 *                         .values("*")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ssm:SendCommand")
 *                     .resources(stopInstance.arn())
 *                     .build())
 *             .build());
 *         var ssmLifecycleRole = new Role("ssmLifecycleRole", RoleArgs.builder()
 *             .assumeRolePolicy(ssmLifecycleTrust.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var ssmLifecyclePolicy = new Policy("ssmLifecyclePolicy", PolicyArgs.builder()
 *             .policy(ssmLifecyclePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(ssmLifecyclePolicyDocument -> ssmLifecyclePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var ssmLifecycleRolePolicyAttachment = new RolePolicyAttachment("ssmLifecycleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn(ssmLifecyclePolicy.arn())
 *             .role(ssmLifecycleRole.name())
 *             .build());
 *         var stopInstancesEventRule = new EventRule("stopInstancesEventRule", EventRuleArgs.builder()
 *             .description("Stop instances nightly")
 *             .scheduleExpression("cron(0 0 * * ? *)")
 *             .build());
 *         var stopInstancesEventTarget = new EventTarget("stopInstancesEventTarget", EventTargetArgs.builder()
 *             .arn(stopInstance.arn())
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(ssmLifecycleRole.arn())
 *             .runCommandTargets(EventTargetRunCommandTargetArgs.builder()
 *                 .key("tag:Terminate")
 *                 .values("midnight")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### RunCommand Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var stopInstancesEventRule = new EventRule("stopInstancesEventRule", EventRuleArgs.builder()
 *             .description("Stop instances nightly")
 *             .scheduleExpression("cron(0 0 * * ? *)")
 *             .build());
 *         var stopInstancesEventTarget = new EventTarget("stopInstancesEventTarget", EventTargetArgs.builder()
 *             .arn(String.format("arn:aws:ssm:%s::document/AWS-RunShellScript", var_.aws_region()))
 *             .input("{\"commands\":[\"halt\"]}")
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(aws_iam_role.ssm_lifecycle().arn())
 *             .runCommandTargets(EventTargetRunCommandTargetArgs.builder()
 *                 .key("tag:Terminate")
 *                 .values("midnight")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### API Gateway target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetHttpTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule("exampleEventRule");
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .deployment(exampleDeployment.id())
 *             .build());
 *         var exampleEventTarget = new EventTarget("exampleEventTarget", EventTargetArgs.builder()
 *             .arn(exampleStage.executionArn().applyValue(executionArn -> String.format("%s/GET", executionArn)))
 *             .rule(exampleEventRule.id())
 *             .httpTarget(EventTargetHttpTargetArgs.builder()
 *                 .queryStringParameters(Map.of("Body", "$.detail.body"))
 *                 .headerParameters(Map.of("Env", "Test"))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Cross-Account Event Bus target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var eventBusInvokeRemoteEventBusRole = new Role("eventBusInvokeRemoteEventBusRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var eventBusInvokeRemoteEventBusPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("events:PutEvents")
 *                 .resources("arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus")
 *                 .build())
 *             .build());
 *         var eventBusInvokeRemoteEventBusPolicy = new Policy("eventBusInvokeRemoteEventBusPolicy", PolicyArgs.builder()
 *             .policy(eventBusInvokeRemoteEventBusPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var eventBusInvokeRemoteEventBusRolePolicyAttachment = new RolePolicyAttachment("eventBusInvokeRemoteEventBusRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(eventBusInvokeRemoteEventBusRole.name())
 *             .policyArn(eventBusInvokeRemoteEventBusPolicy.arn())
 *             .build());
 *         var stopInstancesEventRule = new EventRule("stopInstancesEventRule", EventRuleArgs.builder()
 *             .description("Stop instances nightly")
 *             .scheduleExpression("cron(0 0 * * ? *)")
 *             .build());
 *         var stopInstancesEventTarget = new EventTarget("stopInstancesEventTarget", EventTargetArgs.builder()
 *             .arn("arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus")
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(eventBusInvokeRemoteEventBusRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Input Transformer Usage - JSON Object
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule("exampleEventRule");
 *         var exampleEventTarget = new EventTarget("exampleEventTarget", EventTargetArgs.builder()
 *             .arn(aws_lambda_function.example().arn())
 *             .rule(exampleEventRule.id())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry("instance", "$.detail.instance"),
 *                     Map.entry("status", "$.detail.status")
 *                 ))
 *                 .inputTemplate("""
 * {
 *   "instance_id": <instance>,
 *   "instance_status": <status>
 * }
 *                 """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Input Transformer Usage - Simple String
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule("exampleEventRule");
 *         var exampleEventTarget = new EventTarget("exampleEventTarget", EventTargetArgs.builder()
 *             .arn(aws_lambda_function.example().arn())
 *             .rule(exampleEventRule.id())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry("instance", "$.detail.instance"),
 *                     Map.entry("status", "$.detail.status")
 *                 ))
 *                 .inputTemplate("\"<instance> is in state <status>\"")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Cloudwatch Log Group Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .retentionInDays(1)
 *             .build());
 *         var exampleEventRule = new EventRule("exampleEventRule", EventRuleArgs.builder()
 *             .description("GuardDuty Findings")
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("source", jsonArray("aws.guardduty"))
 *                 )))
 *             .tags(Map.of("Environment", "example"))
 *             .build());
 *         final var exampleLogPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("logs:CreateLogStream")
 *                     .resources(exampleLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers(
 *                             "events.amazonaws.com",
 *                             "delivery.logs.amazonaws.com")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("logs:PutLogEvents")
 *                     .resources(exampleLogGroup.arn().applyValue(arn -> String.format("%s:*:*", arn)))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers(
 *                             "events.amazonaws.com",
 *                             "delivery.logs.amazonaws.com")
 *                         .build())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("ArnEquals")
 *                         .values(exampleEventRule.arn())
 *                         .variable("aws:SourceArn")
 *                         .build())
 *                     .build())
 *             .build());
 *         var exampleLogResourcePolicy = new LogResourcePolicy("exampleLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(exampleLogPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(exampleLogPolicy -> exampleLogPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .policyName("guardduty-log-publishing-policy")
 *             .build());
 *         var exampleEventTarget = new EventTarget("exampleEventTarget", EventTargetArgs.builder()
 *             .rule(exampleEventRule.name())
 *             .arn(exampleLogGroup.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge Targets using `event_bus_name/rule-name/target-id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventTarget:EventTarget test-event-target rule-name/target-id
 * ```
 * */
 */
public class EventTarget internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.EventTarget,
) : KotlinCustomResource(javaResource, EventTargetMapper) {
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
     */
    public val batchTarget: Output<EventTargetBatchTarget>?
        get() = javaResource.batchTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventTargetBatchTargetToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
     */
    public val deadLetterConfig: Output<EventTargetDeadLetterConfig>?
        get() = javaResource.deadLetterConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventTargetDeadLetterConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
     */
    public val ecsTarget: Output<EventTargetEcsTarget>?
        get() = javaResource.ecsTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventTargetEcsTargetToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name or ARN of the event bus to associate with the rule.
     * If you omit this, the `default` event bus is used.
     */
    public val eventBusName: Output<String>?
        get() = javaResource.eventBusName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
     */
    public val httpTarget: Output<EventTargetHttpTarget>?
        get() = javaResource.httpTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventTargetHttpTargetToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
     */
    public val input: Output<String>?
        get() = javaResource.input().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
     */
    public val inputPath: Output<String>?
        get() = javaResource.inputPath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
     */
    public val inputTransformer: Output<EventTargetInputTransformer>?
        get() = javaResource.inputTransformer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventTargetInputTransformerToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
     */
    public val kinesisTarget: Output<EventTargetKinesisTarget>?
        get() = javaResource.kinesisTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventTargetKinesisTargetToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
     */
    public val redshiftTarget: Output<EventTargetRedshiftTarget>?
        get() = javaResource.redshiftTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventTargetRedshiftTargetToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
     */
    public val retryPolicy: Output<EventTargetRetryPolicy>?
        get() = javaResource.retryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventTargetRetryPolicyToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the rule you want to add targets to.
     * The following arguments are optional:
     */
    public val rule: Output<String>
        get() = javaResource.rule().applyValue({ args0 -> args0 })

    /**
     * Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     */
    public val runCommandTargets: Output<List<EventTargetRunCommandTarget>>?
        get() = javaResource.runCommandTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventTargetRunCommandTargetToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
     */
    public val sagemakerPipelineTarget: Output<EventTargetSagemakerPipelineTarget>?
        get() = javaResource.sagemakerPipelineTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventTargetSagemakerPipelineTargetToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
     */
    public val sqsTarget: Output<EventTargetSqsTarget>?
        get() = javaResource.sqsTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventTargetSqsTargetToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The unique target assignment ID. If missing, will generate a random, unique id.
     */
    public val targetId: Output<String>
        get() = javaResource.targetId().applyValue({ args0 -> args0 })
}

public object EventTargetMapper : ResourceMapper<EventTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.EventTarget::class == javaResource::class

    override fun map(javaResource: Resource): EventTarget = EventTarget(
        javaResource as
            com.pulumi.aws.cloudwatch.EventTarget,
    )
}

/**
 * @see [EventTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventTarget].
 */
public suspend fun eventTarget(name: String, block: suspend EventTargetResourceBuilder.() -> Unit):
    EventTarget {
    val builder = EventTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventTarget(name: String): EventTarget {
    val builder = EventTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
