@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.EventTargetArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetBatchTargetArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetBatchTargetArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetDeadLetterConfigArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetDeadLetterConfigArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetEcsTargetArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetEcsTargetArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetHttpTargetArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetHttpTargetArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetInputTransformerArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetInputTransformerArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetKinesisTargetArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetKinesisTargetArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetRedshiftTargetArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetRedshiftTargetArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetRetryPolicyArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetRetryPolicyArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetRunCommandTargetArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetRunCommandTargetArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetSagemakerPipelineTargetArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetSagemakerPipelineTargetArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetSqsTargetArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.EventTargetSqsTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Target resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ### Kinesis Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var console = new EventRule("console", EventRuleArgs.builder()
 *             .description("Capture all EC2 scaling events")
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("source", jsonArray("aws.autoscaling")),
 *                     jsonProperty("detail-type", jsonArray(
 *                         "EC2 Instance Launch Successful",
 *                         "EC2 Instance Terminate Successful",
 *                         "EC2 Instance Launch Unsuccessful",
 *                         "EC2 Instance Terminate Unsuccessful"
 *                     ))
 *                 )))
 *             .build());
 *         var testStream = new Stream("testStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var yada = new EventTarget("yada", EventTargetArgs.builder()
 *             .rule(console.name())
 *             .arn(testStream.arn())
 *             .runCommandTargets(
 *                 EventTargetRunCommandTargetArgs.builder()
 *                     .key("tag:Name")
 *                     .values("FooBar")
 *                     .build(),
 *                 EventTargetRunCommandTargetArgs.builder()
 *                     .key("InstanceIds")
 *                     .values("i-162058cd308bffec2")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SSM Document Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ssm.Document;
 * import com.pulumi.aws.ssm.DocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ssmLifecycleTrust = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var stopInstance = new Document("stopInstance", DocumentArgs.builder()
 *             .documentType("Command")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("schemaVersion", "1.2"),
 *                     jsonProperty("description", "Stop an instance"),
 *                     jsonProperty("parameters", jsonObject(
 *                     )),
 *                     jsonProperty("runtimeConfig", jsonObject(
 *                         jsonProperty("aws:runShellScript", jsonObject(
 *                             jsonProperty("properties", jsonArray(jsonObject(
 *                                 jsonProperty("id", "0.aws:runShellScript"),
 *                                 jsonProperty("runCommand", jsonArray("halt"))
 *                             )))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         final var ssmLifecyclePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ssm:SendCommand")
 *                     .resources("arn:aws:ec2:eu-west-1:1234567890:instance/*")
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("ec2:ResourceTag/Terminate")
 *                         .values("*")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ssm:SendCommand")
 *                     .resources(stopInstance.arn())
 *                     .build())
 *             .build());
 *         var ssmLifecycleRole = new Role("ssmLifecycleRole", RoleArgs.builder()
 *             .assumeRolePolicy(ssmLifecycleTrust.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var ssmLifecyclePolicy = new Policy("ssmLifecyclePolicy", PolicyArgs.builder()
 *             .policy(ssmLifecyclePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(ssmLifecyclePolicyDocument -> ssmLifecyclePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var ssmLifecycleRolePolicyAttachment = new RolePolicyAttachment("ssmLifecycleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn(ssmLifecyclePolicy.arn())
 *             .role(ssmLifecycleRole.name())
 *             .build());
 *         var stopInstancesEventRule = new EventRule("stopInstancesEventRule", EventRuleArgs.builder()
 *             .description("Stop instances nightly")
 *             .scheduleExpression("cron(0 0 * * ? *)")
 *             .build());
 *         var stopInstancesEventTarget = new EventTarget("stopInstancesEventTarget", EventTargetArgs.builder()
 *             .arn(stopInstance.arn())
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(ssmLifecycleRole.arn())
 *             .runCommandTargets(EventTargetRunCommandTargetArgs.builder()
 *                 .key("tag:Terminate")
 *                 .values("midnight")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### RunCommand Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var stopInstancesEventRule = new EventRule("stopInstancesEventRule", EventRuleArgs.builder()
 *             .description("Stop instances nightly")
 *             .scheduleExpression("cron(0 0 * * ? *)")
 *             .build());
 *         var stopInstancesEventTarget = new EventTarget("stopInstancesEventTarget", EventTargetArgs.builder()
 *             .arn(String.format("arn:aws:ssm:%s::document/AWS-RunShellScript", var_.aws_region()))
 *             .input("{\"commands\":[\"halt\"]}")
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(aws_iam_role.ssm_lifecycle().arn())
 *             .runCommandTargets(EventTargetRunCommandTargetArgs.builder()
 *                 .key("tag:Terminate")
 *                 .values("midnight")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### API Gateway target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetHttpTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule("exampleEventRule");
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .deployment(exampleDeployment.id())
 *             .build());
 *         var exampleEventTarget = new EventTarget("exampleEventTarget", EventTargetArgs.builder()
 *             .arn(exampleStage.executionArn().applyValue(executionArn -> String.format("%s/GET", executionArn)))
 *             .rule(exampleEventRule.id())
 *             .httpTarget(EventTargetHttpTargetArgs.builder()
 *                 .queryStringParameters(Map.of("Body", "$.detail.body"))
 *                 .headerParameters(Map.of("Env", "Test"))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Cross-Account Event Bus target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var eventBusInvokeRemoteEventBusRole = new Role("eventBusInvokeRemoteEventBusRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var eventBusInvokeRemoteEventBusPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("events:PutEvents")
 *                 .resources("arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus")
 *                 .build())
 *             .build());
 *         var eventBusInvokeRemoteEventBusPolicy = new Policy("eventBusInvokeRemoteEventBusPolicy", PolicyArgs.builder()
 *             .policy(eventBusInvokeRemoteEventBusPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var eventBusInvokeRemoteEventBusRolePolicyAttachment = new RolePolicyAttachment("eventBusInvokeRemoteEventBusRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(eventBusInvokeRemoteEventBusRole.name())
 *             .policyArn(eventBusInvokeRemoteEventBusPolicy.arn())
 *             .build());
 *         var stopInstancesEventRule = new EventRule("stopInstancesEventRule", EventRuleArgs.builder()
 *             .description("Stop instances nightly")
 *             .scheduleExpression("cron(0 0 * * ? *)")
 *             .build());
 *         var stopInstancesEventTarget = new EventTarget("stopInstancesEventTarget", EventTargetArgs.builder()
 *             .arn("arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus")
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(eventBusInvokeRemoteEventBusRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Input Transformer Usage - JSON Object
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule("exampleEventRule");
 *         var exampleEventTarget = new EventTarget("exampleEventTarget", EventTargetArgs.builder()
 *             .arn(aws_lambda_function.example().arn())
 *             .rule(exampleEventRule.id())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry("instance", "$.detail.instance"),
 *                     Map.entry("status", "$.detail.status")
 *                 ))
 *                 .inputTemplate("""
 * {
 *   "instance_id": <instance>,
 *   "instance_status": <status>
 * }
 *                 """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Input Transformer Usage - Simple String
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule("exampleEventRule");
 *         var exampleEventTarget = new EventTarget("exampleEventTarget", EventTargetArgs.builder()
 *             .arn(aws_lambda_function.example().arn())
 *             .rule(exampleEventRule.id())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry("instance", "$.detail.instance"),
 *                     Map.entry("status", "$.detail.status")
 *                 ))
 *                 .inputTemplate("\"<instance> is in state <status>\"")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Cloudwatch Log Group Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .retentionInDays(1)
 *             .build());
 *         var exampleEventRule = new EventRule("exampleEventRule", EventRuleArgs.builder()
 *             .description("GuardDuty Findings")
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("source", jsonArray("aws.guardduty"))
 *                 )))
 *             .tags(Map.of("Environment", "example"))
 *             .build());
 *         final var exampleLogPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("logs:CreateLogStream")
 *                     .resources(exampleLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers(
 *                             "events.amazonaws.com",
 *                             "delivery.logs.amazonaws.com")
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("logs:PutLogEvents")
 *                     .resources(exampleLogGroup.arn().applyValue(arn -> String.format("%s:*:*", arn)))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers(
 *                             "events.amazonaws.com",
 *                             "delivery.logs.amazonaws.com")
 *                         .build())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("ArnEquals")
 *                         .values(exampleEventRule.arn())
 *                         .variable("aws:SourceArn")
 *                         .build())
 *                     .build())
 *             .build());
 *         var exampleLogResourcePolicy = new LogResourcePolicy("exampleLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(exampleLogPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(exampleLogPolicy -> exampleLogPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .policyName("guardduty-log-publishing-policy")
 *             .build());
 *         var exampleEventTarget = new EventTarget("exampleEventTarget", EventTargetArgs.builder()
 *             .rule(exampleEventRule.name())
 *             .arn(exampleLogGroup.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge Targets using `event_bus_name/rule-name/target-id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventTarget:EventTarget test-event-target rule-name/target-id
 * ```
 * @property arn The Amazon Resource Name (ARN) of the target.
 * @property batchTarget Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
 * @property deadLetterConfig Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
 * @property ecsTarget Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
 * @property eventBusName The name or ARN of the event bus to associate with the rule.
 * If you omit this, the `default` event bus is used.
 * @property httpTarget Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
 * @property input Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
 * @property inputPath The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
 * @property inputTransformer Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
 * @property kinesisTarget Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
 * @property redshiftTarget Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
 * @property retryPolicy Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
 * @property rule The name of the rule you want to add targets to.
 * The following arguments are optional:
 * @property runCommandTargets Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
 * @property sagemakerPipelineTarget Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
 * @property sqsTarget Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
 * @property targetId The unique target assignment ID. If missing, will generate a random, unique id.
 * */
 */
public data class EventTargetArgs(
    public val arn: Output<String>? = null,
    public val batchTarget: Output<EventTargetBatchTargetArgs>? = null,
    public val deadLetterConfig: Output<EventTargetDeadLetterConfigArgs>? = null,
    public val ecsTarget: Output<EventTargetEcsTargetArgs>? = null,
    public val eventBusName: Output<String>? = null,
    public val httpTarget: Output<EventTargetHttpTargetArgs>? = null,
    public val input: Output<String>? = null,
    public val inputPath: Output<String>? = null,
    public val inputTransformer: Output<EventTargetInputTransformerArgs>? = null,
    public val kinesisTarget: Output<EventTargetKinesisTargetArgs>? = null,
    public val redshiftTarget: Output<EventTargetRedshiftTargetArgs>? = null,
    public val retryPolicy: Output<EventTargetRetryPolicyArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val rule: Output<String>? = null,
    public val runCommandTargets: Output<List<EventTargetRunCommandTargetArgs>>? = null,
    public val sagemakerPipelineTarget: Output<EventTargetSagemakerPipelineTargetArgs>? = null,
    public val sqsTarget: Output<EventTargetSqsTargetArgs>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.EventTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.EventTargetArgs =
        com.pulumi.aws.cloudwatch.EventTargetArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .batchTarget(batchTarget?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deadLetterConfig(deadLetterConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ecsTarget(ecsTarget?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventBusName(eventBusName?.applyValue({ args0 -> args0 }))
            .httpTarget(httpTarget?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .input(input?.applyValue({ args0 -> args0 }))
            .inputPath(inputPath?.applyValue({ args0 -> args0 }))
            .inputTransformer(inputTransformer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kinesisTarget(kinesisTarget?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redshiftTarget(redshiftTarget?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .rule(rule?.applyValue({ args0 -> args0 }))
            .runCommandTargets(
                runCommandTargets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sagemakerPipelineTarget(
                sagemakerPipelineTarget?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqsTarget(sqsTarget?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetArgs].
 */
@PulumiTagMarker
public class EventTargetArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var batchTarget: Output<EventTargetBatchTargetArgs>? = null

    private var deadLetterConfig: Output<EventTargetDeadLetterConfigArgs>? = null

    private var ecsTarget: Output<EventTargetEcsTargetArgs>? = null

    private var eventBusName: Output<String>? = null

    private var httpTarget: Output<EventTargetHttpTargetArgs>? = null

    private var input: Output<String>? = null

    private var inputPath: Output<String>? = null

    private var inputTransformer: Output<EventTargetInputTransformerArgs>? = null

    private var kinesisTarget: Output<EventTargetKinesisTargetArgs>? = null

    private var redshiftTarget: Output<EventTargetRedshiftTargetArgs>? = null

    private var retryPolicy: Output<EventTargetRetryPolicyArgs>? = null

    private var roleArn: Output<String>? = null

    private var rule: Output<String>? = null

    private var runCommandTargets: Output<List<EventTargetRunCommandTargetArgs>>? = null

    private var sagemakerPipelineTarget: Output<EventTargetSagemakerPipelineTargetArgs>? = null

    private var sqsTarget: Output<EventTargetSqsTargetArgs>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the target.
     */
    @JvmName("ouesowmfcaojcyve")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("aplalxwwcrvhpjok")
    public suspend fun batchTarget(`value`: Output<EventTargetBatchTargetArgs>) {
        this.batchTarget = value
    }

    /**
     * @param value Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("mdfmroxrsnivmqea")
    public suspend fun deadLetterConfig(`value`: Output<EventTargetDeadLetterConfigArgs>) {
        this.deadLetterConfig = value
    }

    /**
     * @param value Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("ywcngrbokablgjwd")
    public suspend fun ecsTarget(`value`: Output<EventTargetEcsTargetArgs>) {
        this.ecsTarget = value
    }

    /**
     * @param value The name or ARN of the event bus to associate with the rule.
     * If you omit this, the `default` event bus is used.
     */
    @JvmName("awcskimgoiqxtokf")
    public suspend fun eventBusName(`value`: Output<String>) {
        this.eventBusName = value
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
     */
    @JvmName("jscuatfhlaxkgwca")
    public suspend fun httpTarget(`value`: Output<EventTargetHttpTargetArgs>) {
        this.httpTarget = value
    }

    /**
     * @param value Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
     */
    @JvmName("jlypuyggaepuaagd")
    public suspend fun input(`value`: Output<String>) {
        this.input = value
    }

    /**
     * @param value The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
     */
    @JvmName("igrkrxmhsesxqndg")
    public suspend fun inputPath(`value`: Output<String>) {
        this.inputPath = value
    }

    /**
     * @param value Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
     */
    @JvmName("xdwvaypfjemqxuis")
    public suspend fun inputTransformer(`value`: Output<EventTargetInputTransformerArgs>) {
        this.inputTransformer = value
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("msxqskcusgsxfoco")
    public suspend fun kinesisTarget(`value`: Output<EventTargetKinesisTargetArgs>) {
        this.kinesisTarget = value
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("yvnqsimqcwicyttk")
    public suspend fun redshiftTarget(`value`: Output<EventTargetRedshiftTargetArgs>) {
        this.redshiftTarget = value
    }

    /**
     * @param value Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("gsjcllsvbaysaeae")
    public suspend fun retryPolicy(`value`: Output<EventTargetRetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
     */
    @JvmName("djjfelbufqclhqtw")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the rule you want to add targets to.
     * The following arguments are optional:
     */
    @JvmName("jnifncnlgqjwwlpv")
    public suspend fun rule(`value`: Output<String>) {
        this.rule = value
    }

    /**
     * @param value Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     */
    @JvmName("sdcvhmyspsgmoupw")
    public suspend fun runCommandTargets(`value`: Output<List<EventTargetRunCommandTargetArgs>>) {
        this.runCommandTargets = value
    }

    @JvmName("qtfrfubfrdoqvhxo")
    public suspend fun runCommandTargets(vararg values: Output<EventTargetRunCommandTargetArgs>) {
        this.runCommandTargets = Output.all(values.asList())
    }

    /**
     * @param values Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     */
    @JvmName("raaiyfkbmmennjsf")
    public suspend fun runCommandTargets(values: List<Output<EventTargetRunCommandTargetArgs>>) {
        this.runCommandTargets = Output.all(values)
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("mntxjhijqfccrfjd")
    public suspend
    fun sagemakerPipelineTarget(`value`: Output<EventTargetSagemakerPipelineTargetArgs>) {
        this.sagemakerPipelineTarget = value
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("jbqhfoegtpkgrrsg")
    public suspend fun sqsTarget(`value`: Output<EventTargetSqsTargetArgs>) {
        this.sqsTarget = value
    }

    /**
     * @param value The unique target assignment ID. If missing, will generate a random, unique id.
     */
    @JvmName("sxnymahjjkguibwe")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the target.
     */
    @JvmName("bxjtuxdeqtchoubx")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("aijmeafwmwonlrcg")
    public suspend fun batchTarget(`value`: EventTargetBatchTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchTarget = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("wqkmsrpmnvhphtrq")
    public suspend fun batchTarget(argument: suspend EventTargetBatchTargetArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetBatchTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.batchTarget = mapped
    }

    /**
     * @param value Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("xauhjtpxdwmmqigs")
    public suspend fun deadLetterConfig(`value`: EventTargetDeadLetterConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterConfig = mapped
    }

    /**
     * @param argument Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("acjbncdisbxmwkqc")
    public suspend
    fun deadLetterConfig(argument: suspend EventTargetDeadLetterConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetDeadLetterConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deadLetterConfig = mapped
    }

    /**
     * @param value Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("ygqriglohtamrhih")
    public suspend fun ecsTarget(`value`: EventTargetEcsTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsTarget = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("bpgnumgykxqvkgoy")
    public suspend fun ecsTarget(argument: suspend EventTargetEcsTargetArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetEcsTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ecsTarget = mapped
    }

    /**
     * @param value The name or ARN of the event bus to associate with the rule.
     * If you omit this, the `default` event bus is used.
     */
    @JvmName("wipgbcxgdsjjlhyd")
    public suspend fun eventBusName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBusName = mapped
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
     */
    @JvmName("heexmdwgcgubxgpt")
    public suspend fun httpTarget(`value`: EventTargetHttpTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpTarget = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
     */
    @JvmName("lkxawchwdkkpbroo")
    public suspend fun httpTarget(argument: suspend EventTargetHttpTargetArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetHttpTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpTarget = mapped
    }

    /**
     * @param value Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
     */
    @JvmName("verxgxxtldigshhd")
    public suspend fun input(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param value The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
     */
    @JvmName("qombmxbiqettsonk")
    public suspend fun inputPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputPath = mapped
    }

    /**
     * @param value Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
     */
    @JvmName("qqeadxwyynxkmpow")
    public suspend fun inputTransformer(`value`: EventTargetInputTransformerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputTransformer = mapped
    }

    /**
     * @param argument Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
     */
    @JvmName("sjywwmvcwhnxvtaf")
    public suspend
    fun inputTransformer(argument: suspend EventTargetInputTransformerArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetInputTransformerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputTransformer = mapped
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("turbggesoseefrcc")
    public suspend fun kinesisTarget(`value`: EventTargetKinesisTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisTarget = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("ulwlsmqhfqwkudda")
    public suspend
    fun kinesisTarget(argument: suspend EventTargetKinesisTargetArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetKinesisTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kinesisTarget = mapped
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("mkehpyuhomelnwui")
    public suspend fun redshiftTarget(`value`: EventTargetRedshiftTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftTarget = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("smvbbsmuaxaymbju")
    public suspend
    fun redshiftTarget(argument: suspend EventTargetRedshiftTargetArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetRedshiftTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redshiftTarget = mapped
    }

    /**
     * @param value Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("bkockeqkfcqeopja")
    public suspend fun retryPolicy(`value`: EventTargetRetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("scdobkdogdfwlgwo")
    public suspend fun retryPolicy(argument: suspend EventTargetRetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetRetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
     */
    @JvmName("visukpvewpwjrymy")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the rule you want to add targets to.
     * The following arguments are optional:
     */
    @JvmName("nojkbhxathbwuoin")
    public suspend fun rule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rule = mapped
    }

    /**
     * @param value Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     */
    @JvmName("rkwlkfedqcuuxqwg")
    public suspend fun runCommandTargets(`value`: List<EventTargetRunCommandTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runCommandTargets = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     */
    @JvmName("hqudbtswqdjtcocc")
    public suspend
    fun runCommandTargets(argument: List<suspend EventTargetRunCommandTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventTargetRunCommandTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.runCommandTargets = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     */
    @JvmName("dmxotwfywfrnpxmi")
    public suspend fun runCommandTargets(
        vararg
        argument: suspend EventTargetRunCommandTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventTargetRunCommandTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.runCommandTargets = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     */
    @JvmName("wthmyppknwqupqne")
    public suspend
    fun runCommandTargets(argument: suspend EventTargetRunCommandTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventTargetRunCommandTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.runCommandTargets = mapped
    }

    /**
     * @param values Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     */
    @JvmName("ipohmpmqhpnfbrbt")
    public suspend fun runCommandTargets(vararg values: EventTargetRunCommandTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runCommandTargets = mapped
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("qrckawjupmmrasgv")
    public suspend fun sagemakerPipelineTarget(`value`: EventTargetSagemakerPipelineTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerPipelineTarget = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("rdtgtcpkxrfaufnh")
    public suspend
    fun sagemakerPipelineTarget(argument: suspend EventTargetSagemakerPipelineTargetArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetSagemakerPipelineTargetArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sagemakerPipelineTarget = mapped
    }

    /**
     * @param value Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("hnmeweqrwmmyaaki")
    public suspend fun sqsTarget(`value`: EventTargetSqsTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqsTarget = mapped
    }

    /**
     * @param argument Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
     */
    @JvmName("aihrvkgvtkxobgwx")
    public suspend fun sqsTarget(argument: suspend EventTargetSqsTargetArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetSqsTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqsTarget = mapped
    }

    /**
     * @param value The unique target assignment ID. If missing, will generate a random, unique id.
     */
    @JvmName("cvqithbddmmilltn")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): EventTargetArgs = EventTargetArgs(
        arn = arn,
        batchTarget = batchTarget,
        deadLetterConfig = deadLetterConfig,
        ecsTarget = ecsTarget,
        eventBusName = eventBusName,
        httpTarget = httpTarget,
        input = input,
        inputPath = inputPath,
        inputTransformer = inputTransformer,
        kinesisTarget = kinesisTarget,
        redshiftTarget = redshiftTarget,
        retryPolicy = retryPolicy,
        roleArn = roleArn,
        rule = rule,
        runCommandTargets = runCommandTargets,
        sagemakerPipelineTarget = sagemakerPipelineTarget,
        sqsTarget = sqsTarget,
        targetId = targetId,
    )
}
