@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.InternetMonitorHealthEventsConfig
import com.pulumi.aws.cloudwatch.kotlin.outputs.InternetMonitorInternetMeasurementsLogDelivery
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudwatch.kotlin.outputs.InternetMonitorHealthEventsConfig.Companion.toKotlin as internetMonitorHealthEventsConfigToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.InternetMonitorInternetMeasurementsLogDelivery.Companion.toKotlin as internetMonitorInternetMeasurementsLogDeliveryToKotlin

/**
 * Builder for [InternetMonitor].
 */
@PulumiTagMarker
public class InternetMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InternetMonitorArgs = InternetMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InternetMonitorArgsBuilder.() -> Unit) {
        val builder = InternetMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InternetMonitor {
        val builtJavaResource = com.pulumi.aws.cloudwatch.InternetMonitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InternetMonitor(builtJavaResource)
    }
}

/**
 * Provides a Internet Monitor Monitor resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.InternetMonitor;
 * import com.pulumi.aws.cloudwatch.InternetMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InternetMonitor("example", InternetMonitorArgs.builder()
 *             .monitorName("exmple")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Internet Monitor Monitors using the `monitor_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/internetMonitor:InternetMonitor some some-monitor
 * ```
 *
 */
public class InternetMonitor internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.InternetMonitor,
) : KotlinCustomResource(javaResource, InternetMonitorMapper) {
    /**
     * ARN of the Monitor.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
     */
    public val healthEventsConfig: Output<InternetMonitorHealthEventsConfig>?
        get() = javaResource.healthEventsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> internetMonitorHealthEventsConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
     */
    public val internetMeasurementsLogDelivery:
        Output<InternetMonitorInternetMeasurementsLogDelivery>?
        get() = javaResource.internetMeasurementsLogDelivery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    internetMonitorInternetMeasurementsLogDeliveryToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
     */
    public val maxCityNetworksToMonitor: Output<Int>?
        get() = javaResource.maxCityNetworksToMonitor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the monitor.
     * The following arguments are optional:
     */
    public val monitorName: Output<String>
        get() = javaResource.monitorName().applyValue({ args0 -> args0 })

    /**
     * The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    public val resources: Output<List<String>>?
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
     */
    public val trafficPercentageToMonitor: Output<Int>?
        get() = javaResource.trafficPercentageToMonitor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object InternetMonitorMapper : ResourceMapper<InternetMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.InternetMonitor::class == javaResource::class

    override fun map(javaResource: Resource): InternetMonitor = InternetMonitor(
        javaResource as
            com.pulumi.aws.cloudwatch.InternetMonitor,
    )
}

/**
 * @see [InternetMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InternetMonitor].
 */
public suspend fun internetMonitor(
    name: String,
    block: suspend InternetMonitorResourceBuilder.() -> Unit,
): InternetMonitor {
    val builder = InternetMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InternetMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun internetMonitor(name: String): InternetMonitor {
    val builder = InternetMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
