@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogDataProtectionPolicy].
 */
@PulumiTagMarker
public class LogDataProtectionPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogDataProtectionPolicyArgs = LogDataProtectionPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogDataProtectionPolicyArgsBuilder.() -> Unit) {
        val builder = LogDataProtectionPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LogDataProtectionPolicy {
        val builtJavaResource =
            com.pulumi.aws.cloudwatch.LogDataProtectionPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LogDataProtectionPolicy(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Log Data Protection Policy resource.
 * Read more about protecting sensitive user data in the [User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.cloudwatch.LogDataProtectionPolicy;
 * import com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleLogDataProtectionPolicy = new LogDataProtectionPolicy("exampleLogDataProtectionPolicy", LogDataProtectionPolicyArgs.builder()
 *             .logGroupName(exampleLogGroup.name())
 *             .policyDocument(exampleBucketV2.bucket().applyValue(bucket -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Name", "Example"),
 *                     jsonProperty("Version", "2021-06-01"),
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Sid", "Audit"),
 *                             jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                             jsonProperty("Operation", jsonObject(
 *                                 jsonProperty("Audit", jsonObject(
 *                                     jsonProperty("FindingsDestination", jsonObject(
 *                                         jsonProperty("S3", jsonObject(
 *                                             jsonProperty("Bucket", bucket)
 *                                         ))
 *                                     ))
 *                                 ))
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Sid", "Redact"),
 *                             jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                             jsonProperty("Operation", jsonObject(
 *                                 jsonProperty("Deidentify", jsonObject(
 *                                     jsonProperty("MaskConfig", jsonObject(
 *                                     ))
 *                                 ))
 *                             ))
 *                         )
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import this resource using the `log_group_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logDataProtectionPolicy:LogDataProtectionPolicy example my-log-group
 * ```
 *
 */
public class LogDataProtectionPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogDataProtectionPolicy,
) : KotlinCustomResource(javaResource, LogDataProtectionPolicyMapper) {
    /**
     * The name of the log group under which the log stream is to be created.
     */
    public val logGroupName: Output<String>
        get() = javaResource.logGroupName().applyValue({ args0 -> args0 })

    /**
     * Specifies the data protection policy in JSON. Read more at [Data protection policy syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-start.html#mask-sensitive-log-data-policysyntax).
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })
}

public object LogDataProtectionPolicyMapper : ResourceMapper<LogDataProtectionPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogDataProtectionPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LogDataProtectionPolicy =
        LogDataProtectionPolicy(javaResource as com.pulumi.aws.cloudwatch.LogDataProtectionPolicy)
}

/**
 * @see [LogDataProtectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogDataProtectionPolicy].
 */
public suspend fun logDataProtectionPolicy(
    name: String,
    block: suspend LogDataProtectionPolicyResourceBuilder.() -> Unit,
): LogDataProtectionPolicy {
    val builder = LogDataProtectionPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogDataProtectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logDataProtectionPolicy(name: String): LogDataProtectionPolicy {
    val builder = LogDataProtectionPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
