@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Log Data Protection Policy resource.
 * Read more about protecting sensitive user data in the [User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.cloudwatch.LogDataProtectionPolicy;
 * import com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleLogDataProtectionPolicy = new LogDataProtectionPolicy("exampleLogDataProtectionPolicy", LogDataProtectionPolicyArgs.builder()
 *             .logGroupName(exampleLogGroup.name())
 *             .policyDocument(exampleBucketV2.bucket().applyValue(bucket -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Name", "Example"),
 *                     jsonProperty("Version", "2021-06-01"),
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Sid", "Audit"),
 *                             jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                             jsonProperty("Operation", jsonObject(
 *                                 jsonProperty("Audit", jsonObject(
 *                                     jsonProperty("FindingsDestination", jsonObject(
 *                                         jsonProperty("S3", jsonObject(
 *                                             jsonProperty("Bucket", bucket)
 *                                         ))
 *                                     ))
 *                                 ))
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Sid", "Redact"),
 *                             jsonProperty("DataIdentifier", jsonArray("arn:aws:dataprotection::aws:data-identifier/EmailAddress")),
 *                             jsonProperty("Operation", jsonObject(
 *                                 jsonProperty("Deidentify", jsonObject(
 *                                     jsonProperty("MaskConfig", jsonObject(
 *                                     ))
 *                                 ))
 *                             ))
 *                         )
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import this resource using the `log_group_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logDataProtectionPolicy:LogDataProtectionPolicy example my-log-group
 * ```
 * @property logGroupName The name of the log group under which the log stream is to be created.
 * @property policyDocument Specifies the data protection policy in JSON. Read more at [Data protection policy syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-start.html#mask-sensitive-log-data-policysyntax).
 */
public data class LogDataProtectionPolicyArgs(
    public val logGroupName: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs =
        com.pulumi.aws.cloudwatch.LogDataProtectionPolicyArgs.builder()
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogDataProtectionPolicyArgs].
 */
@PulumiTagMarker
public class LogDataProtectionPolicyArgsBuilder internal constructor() {
    private var logGroupName: Output<String>? = null

    private var policyDocument: Output<String>? = null

    /**
     * @param value The name of the log group under which the log stream is to be created.
     */
    @JvmName("fmhjsdfhomcehgkl")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value Specifies the data protection policy in JSON. Read more at [Data protection policy syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-start.html#mask-sensitive-log-data-policysyntax).
     */
    @JvmName("woykbvfchhfbbvqq")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The name of the log group under which the log stream is to be created.
     */
    @JvmName("jjuqyomgedlgkanc")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value Specifies the data protection policy in JSON. Read more at [Data protection policy syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-start.html#mask-sensitive-log-data-policysyntax).
     */
    @JvmName("vwapharkqudaxkvh")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    internal fun build(): LogDataProtectionPolicyArgs = LogDataProtectionPolicyArgs(
        logGroupName = logGroupName,
        policyDocument = policyDocument,
    )
}
