@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Logs destination resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogDestination;
 * import com.pulumi.aws.cloudwatch.LogDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testDestination = new LogDestination("testDestination", LogDestinationArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_cloudwatch().arn())
 *             .targetArn(aws_kinesis_stream.kinesis_for_cloudwatch().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Logs destinations using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logDestination:LogDestination test_destination test_destination
 * ```
 * @property name A name for the log destination.
 * @property roleArn The ARN of an IAM role that grants Amazon CloudWatch Logs permissions to put data into the target.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetArn The ARN of the target Amazon Kinesis stream resource for the destination.
 */
public data class LogDestinationArgs(
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogDestinationArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogDestinationArgs =
        com.pulumi.aws.cloudwatch.LogDestinationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetArn(targetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogDestinationArgs].
 */
@PulumiTagMarker
public class LogDestinationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetArn: Output<String>? = null

    /**
     * @param value A name for the log destination.
     */
    @JvmName("pldqxikuycefbtoj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of an IAM role that grants Amazon CloudWatch Logs permissions to put data into the target.
     */
    @JvmName("kpfjgfasbuhdfjwm")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("psndemxonuehofpp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the target Amazon Kinesis stream resource for the destination.
     */
    @JvmName("oqwkdvjkytpgvwcu")
    public suspend fun targetArn(`value`: Output<String>) {
        this.targetArn = value
    }

    /**
     * @param value A name for the log destination.
     */
    @JvmName("blcrgynqdoncmtha")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of an IAM role that grants Amazon CloudWatch Logs permissions to put data into the target.
     */
    @JvmName("tgvloriwoupaurav")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bhxnoshuqtroeorc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tgvscstlgcoothqv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ARN of the target Amazon Kinesis stream resource for the destination.
     */
    @JvmName("jykcuswyeijqeupf")
    public suspend fun targetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetArn = mapped
    }

    internal fun build(): LogDestinationArgs = LogDestinationArgs(
        name = name,
        roleArn = roleArn,
        tags = tags,
        targetArn = targetArn,
    )
}
