@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogDestinationPolicy].
 */
@PulumiTagMarker
public class LogDestinationPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogDestinationPolicyArgs = LogDestinationPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogDestinationPolicyArgsBuilder.() -> Unit) {
        val builder = LogDestinationPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LogDestinationPolicy {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogDestinationPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogDestinationPolicy(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Logs destination policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogDestination;
 * import com.pulumi.aws.cloudwatch.LogDestinationArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogDestinationPolicy;
 * import com.pulumi.aws.cloudwatch.LogDestinationPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testDestination = new LogDestination("testDestination", LogDestinationArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_cloudwatch().arn())
 *             .targetArn(aws_kinesis_stream.kinesis_for_cloudwatch().arn())
 *             .build());
 *         final var testDestinationPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions("logs:PutSubscriptionFilter")
 *                 .resources(testDestination.arn())
 *                 .build())
 *             .build());
 *         var testDestinationPolicyLogDestinationPolicy = new LogDestinationPolicy("testDestinationPolicyLogDestinationPolicy", LogDestinationPolicyArgs.builder()
 *             .destinationName(testDestination.name())
 *             .accessPolicy(testDestinationPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testDestinationPolicyPolicyDocument -> testDestinationPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Logs destination policies using the `destination_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logDestinationPolicy:LogDestinationPolicy test_destination_policy test_destination
 * ```
 *
 */
public class LogDestinationPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogDestinationPolicy,
) : KotlinCustomResource(javaResource, LogDestinationPolicyMapper) {
    /**
     * The policy document. This is a JSON formatted string.
     */
    public val accessPolicy: Output<String>
        get() = javaResource.accessPolicy().applyValue({ args0 -> args0 })

    /**
     * A name for the subscription filter
     */
    public val destinationName: Output<String>
        get() = javaResource.destinationName().applyValue({ args0 -> args0 })

    /**
     * Specify true if you are updating an existing destination policy to grant permission to an organization ID instead of granting permission to individual AWS accounts.
     */
    public val forceUpdate: Output<Boolean>?
        get() = javaResource.forceUpdate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LogDestinationPolicyMapper : ResourceMapper<LogDestinationPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogDestinationPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LogDestinationPolicy = LogDestinationPolicy(
        javaResource
            as com.pulumi.aws.cloudwatch.LogDestinationPolicy,
    )
}

/**
 * @see [LogDestinationPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogDestinationPolicy].
 */
public suspend fun logDestinationPolicy(
    name: String,
    block: suspend LogDestinationPolicyResourceBuilder.() -> Unit,
): LogDestinationPolicy {
    val builder = LogDestinationPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogDestinationPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logDestinationPolicy(name: String): LogDestinationPolicy {
    val builder = LogDestinationPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
