@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogDestinationPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Logs destination policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogDestination;
 * import com.pulumi.aws.cloudwatch.LogDestinationArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogDestinationPolicy;
 * import com.pulumi.aws.cloudwatch.LogDestinationPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testDestination = new LogDestination("testDestination", LogDestinationArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_cloudwatch().arn())
 *             .targetArn(aws_kinesis_stream.kinesis_for_cloudwatch().arn())
 *             .build());
 *         final var testDestinationPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("123456789012")
 *                     .build())
 *                 .actions("logs:PutSubscriptionFilter")
 *                 .resources(testDestination.arn())
 *                 .build())
 *             .build());
 *         var testDestinationPolicyLogDestinationPolicy = new LogDestinationPolicy("testDestinationPolicyLogDestinationPolicy", LogDestinationPolicyArgs.builder()
 *             .destinationName(testDestination.name())
 *             .accessPolicy(testDestinationPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testDestinationPolicyPolicyDocument -> testDestinationPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Logs destination policies using the `destination_name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logDestinationPolicy:LogDestinationPolicy test_destination_policy test_destination
 * ```
 * @property accessPolicy The policy document. This is a JSON formatted string.
 * @property destinationName A name for the subscription filter
 * @property forceUpdate Specify true if you are updating an existing destination policy to grant permission to an organization ID instead of granting permission to individual AWS accounts.
 */
public data class LogDestinationPolicyArgs(
    public val accessPolicy: Output<String>? = null,
    public val destinationName: Output<String>? = null,
    public val forceUpdate: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogDestinationPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogDestinationPolicyArgs =
        com.pulumi.aws.cloudwatch.LogDestinationPolicyArgs.builder()
            .accessPolicy(accessPolicy?.applyValue({ args0 -> args0 }))
            .destinationName(destinationName?.applyValue({ args0 -> args0 }))
            .forceUpdate(forceUpdate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogDestinationPolicyArgs].
 */
@PulumiTagMarker
public class LogDestinationPolicyArgsBuilder internal constructor() {
    private var accessPolicy: Output<String>? = null

    private var destinationName: Output<String>? = null

    private var forceUpdate: Output<Boolean>? = null

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("bopkhqwugoxiroen")
    public suspend fun accessPolicy(`value`: Output<String>) {
        this.accessPolicy = value
    }

    /**
     * @param value A name for the subscription filter
     */
    @JvmName("dnkxtdssdkyytxrh")
    public suspend fun destinationName(`value`: Output<String>) {
        this.destinationName = value
    }

    /**
     * @param value Specify true if you are updating an existing destination policy to grant permission to an organization ID instead of granting permission to individual AWS accounts.
     */
    @JvmName("tdirfccdpidchncy")
    public suspend fun forceUpdate(`value`: Output<Boolean>) {
        this.forceUpdate = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("mrbjngbjuuiqujvg")
    public suspend fun accessPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicy = mapped
    }

    /**
     * @param value A name for the subscription filter
     */
    @JvmName("fwmeinjobifagdbx")
    public suspend fun destinationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationName = mapped
    }

    /**
     * @param value Specify true if you are updating an existing destination policy to grant permission to an organization ID instead of granting permission to individual AWS accounts.
     */
    @JvmName("lxkmyejsuceqfxrt")
    public suspend fun forceUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdate = mapped
    }

    internal fun build(): LogDestinationPolicyArgs = LogDestinationPolicyArgs(
        accessPolicy = accessPolicy,
        destinationName = destinationName,
        forceUpdate = forceUpdate,
    )
}
