@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogMetricFilterArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.LogMetricFilterMetricTransformationArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.LogMetricFilterMetricTransformationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Log Metric Filter resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogMetricFilter;
 * import com.pulumi.aws.cloudwatch.LogMetricFilterArgs;
 * import com.pulumi.aws.cloudwatch.inputs.LogMetricFilterMetricTransformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dada = new LogGroup("dada");
 *         var yada = new LogMetricFilter("yada", LogMetricFilterArgs.builder()
 *             .pattern("")
 *             .logGroupName(dada.name())
 *             .metricTransformation(LogMetricFilterMetricTransformationArgs.builder()
 *                 .name("EventCount")
 *                 .namespace("YourNamespace")
 *                 .value("1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Log Metric Filter using the `log_group_name:name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logMetricFilter:LogMetricFilter test /aws/lambda/function:test
 * ```
 * @property logGroupName The name of the log group to associate the metric filter with.
 * @property metricTransformation A block defining collection of information needed to define how metric data gets emitted. See below.
 * @property name A name for the metric filter.
 * @property pattern A valid [CloudWatch Logs filter pattern](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/FilterAndPatternSyntax.html)
 * for extracting metric data out of ingested log events.
 */
public data class LogMetricFilterArgs(
    public val logGroupName: Output<String>? = null,
    public val metricTransformation: Output<LogMetricFilterMetricTransformationArgs>? = null,
    public val name: Output<String>? = null,
    public val pattern: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogMetricFilterArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogMetricFilterArgs =
        com.pulumi.aws.cloudwatch.LogMetricFilterArgs.builder()
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
            .metricTransformation(
                metricTransformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .pattern(pattern?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogMetricFilterArgs].
 */
@PulumiTagMarker
public class LogMetricFilterArgsBuilder internal constructor() {
    private var logGroupName: Output<String>? = null

    private var metricTransformation: Output<LogMetricFilterMetricTransformationArgs>? = null

    private var name: Output<String>? = null

    private var pattern: Output<String>? = null

    /**
     * @param value The name of the log group to associate the metric filter with.
     */
    @JvmName("xyhfkapjlswblidk")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value A block defining collection of information needed to define how metric data gets emitted. See below.
     */
    @JvmName("txahvqhnrsgdqflp")
    public suspend
    fun metricTransformation(`value`: Output<LogMetricFilterMetricTransformationArgs>) {
        this.metricTransformation = value
    }

    /**
     * @param value A name for the metric filter.
     */
    @JvmName("jyygoqcdcftcqkvh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A valid [CloudWatch Logs filter pattern](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/FilterAndPatternSyntax.html)
     * for extracting metric data out of ingested log events.
     */
    @JvmName("vfxtgbqkwpblxxov")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value The name of the log group to associate the metric filter with.
     */
    @JvmName("uvtofkafevinclov")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value A block defining collection of information needed to define how metric data gets emitted. See below.
     */
    @JvmName("uftwbjunuomslgmy")
    public suspend fun metricTransformation(`value`: LogMetricFilterMetricTransformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricTransformation = mapped
    }

    /**
     * @param argument A block defining collection of information needed to define how metric data gets emitted. See below.
     */
    @JvmName("wbjwhmcajyvpfnha")
    public suspend
    fun metricTransformation(argument: suspend LogMetricFilterMetricTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = LogMetricFilterMetricTransformationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metricTransformation = mapped
    }

    /**
     * @param value A name for the metric filter.
     */
    @JvmName("vqlcnordfjotfnlm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A valid [CloudWatch Logs filter pattern](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/FilterAndPatternSyntax.html)
     * for extracting metric data out of ingested log events.
     */
    @JvmName("fsacrxmpgdsvyxta")
    public suspend fun pattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    internal fun build(): LogMetricFilterArgs = LogMetricFilterArgs(
        logGroupName = logGroupName,
        metricTransformation = metricTransformation,
        name = name,
        pattern = pattern,
    )
}
