@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogResourcePolicy].
 */
@PulumiTagMarker
public class LogResourcePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogResourcePolicyArgs = LogResourcePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogResourcePolicyArgsBuilder.() -> Unit) {
        val builder = LogResourcePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LogResourcePolicy {
        val builtJavaResource = com.pulumi.aws.cloudwatch.LogResourcePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogResourcePolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a CloudWatch log resource policy.
 * ## Example Usage
 * ### Elasticsearch Log Publishing
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var elasticsearch-log-publishing-policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents",
 *                     "logs:PutLogEventsBatch")
 *                 .resources("arn:aws:logs:*")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("es.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var elasticsearch_log_publishing_policyLogResourcePolicy = new LogResourcePolicy("elasticsearch-log-publishing-policyLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(elasticsearch_log_publishing_policyPolicyDocument.json())
 *             .policyName("elasticsearch-log-publishing-policy")
 *             .build());
 *     }
 * }
 * ```
 * ### Route53 Query Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var route53-query-logging-policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents")
 *                 .resources("arn:aws:logs:*:*:log-group:/aws/route53/*")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("route53.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var route53_query_logging_policyLogResourcePolicy = new LogResourcePolicy("route53-query-logging-policyLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(route53_query_logging_policyPolicyDocument.json())
 *             .policyName("route53-query-logging-policy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch log resource policies using the policy name. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logResourcePolicy:LogResourcePolicy MyPolicy MyPolicy
 * ```
 * */
 */
public class LogResourcePolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.LogResourcePolicy,
) : KotlinCustomResource(javaResource, LogResourcePolicyMapper) {
    /**
     * Details of the resource policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. Maximum length of 5120 characters.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * Name of the resource policy.
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })
}

public object LogResourcePolicyMapper : ResourceMapper<LogResourcePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.LogResourcePolicy::class == javaResource::class

    override fun map(javaResource: Resource): LogResourcePolicy = LogResourcePolicy(
        javaResource as
            com.pulumi.aws.cloudwatch.LogResourcePolicy,
    )
}

/**
 * @see [LogResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogResourcePolicy].
 */
public suspend fun logResourcePolicy(
    name: String,
    block: suspend LogResourcePolicyResourceBuilder.() -> Unit,
): LogResourcePolicy {
    val builder = LogResourcePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logResourcePolicy(name: String): LogResourcePolicy {
    val builder = LogResourcePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
