@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a CloudWatch log resource policy.
 * ## Example Usage
 * ### Elasticsearch Log Publishing
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var elasticsearch-log-publishing-policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents",
 *                     "logs:PutLogEventsBatch")
 *                 .resources("arn:aws:logs:*")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("es.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var elasticsearch_log_publishing_policyLogResourcePolicy = new LogResourcePolicy("elasticsearch-log-publishing-policyLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(elasticsearch_log_publishing_policyPolicyDocument.json())
 *             .policyName("elasticsearch-log-publishing-policy")
 *             .build());
 *     }
 * }
 * ```
 * ### Route53 Query Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var route53-query-logging-policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents")
 *                 .resources("arn:aws:logs:*:*:log-group:/aws/route53/*")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("route53.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var route53_query_logging_policyLogResourcePolicy = new LogResourcePolicy("route53-query-logging-policyLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(route53_query_logging_policyPolicyDocument.json())
 *             .policyName("route53-query-logging-policy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch log resource policies using the policy name. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logResourcePolicy:LogResourcePolicy MyPolicy MyPolicy
 * ```
 * @property policyDocument Details of the resource policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. Maximum length of 5120 characters.
 * @property policyName Name of the resource policy.
 * */
 */
public data class LogResourcePolicyArgs(
    public val policyDocument: Output<String>? = null,
    public val policyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogResourcePolicyArgs =
        com.pulumi.aws.cloudwatch.LogResourcePolicyArgs.builder()
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogResourcePolicyArgs].
 */
@PulumiTagMarker
public class LogResourcePolicyArgsBuilder internal constructor() {
    private var policyDocument: Output<String>? = null

    private var policyName: Output<String>? = null

    /**
     * @param value Details of the resource policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. Maximum length of 5120 characters.
     */
    @JvmName("arjlnolworepsrni")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value Name of the resource policy.
     */
    @JvmName("bmdihrtdbyhsuhoa")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Details of the resource policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. Maximum length of 5120 characters.
     */
    @JvmName("dgnakionujawqyfe")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value Name of the resource policy.
     */
    @JvmName("wfxwqrowrmrmkosi")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    internal fun build(): LogResourcePolicyArgs = LogResourcePolicyArgs(
        policyDocument = policyDocument,
        policyName = policyName,
    )
}
