@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Log Stream resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogStream;
 * import com.pulumi.aws.cloudwatch.LogStreamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var yada = new LogGroup("yada");
 *         var foo = new LogStream("foo", LogStreamArgs.builder()
 *             .logGroupName(yada.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudwatch Log Stream using the stream's `log_group_name` and `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logStream:LogStream foo Yada:SampleLogStream1234
 * ```
 * @property logGroupName The name of the log group under which the log stream is to be created.
 * @property name The name of the log stream. Must not be longer than 512 characters and must not contain `:`
 */
public data class LogStreamArgs(
    public val logGroupName: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogStreamArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogStreamArgs =
        com.pulumi.aws.cloudwatch.LogStreamArgs.builder()
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogStreamArgs].
 */
@PulumiTagMarker
public class LogStreamArgsBuilder internal constructor() {
    private var logGroupName: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The name of the log group under which the log stream is to be created.
     */
    @JvmName("dpxggpqvauldmpxl")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The name of the log stream. Must not be longer than 512 characters and must not contain `:`
     */
    @JvmName("ojflnnmytrpbqmni")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the log group under which the log stream is to be created.
     */
    @JvmName("qxrassfoavrhmqfw")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The name of the log stream. Must not be longer than 512 characters and must not contain `:`
     */
    @JvmName("ashuyklalpaxnxbf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): LogStreamArgs = LogStreamArgs(
        logGroupName = logGroupName,
        name = name,
    )
}
