@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.LogSubscriptionFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Logs subscription filter resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogSubscriptionFilter;
 * import com.pulumi.aws.cloudwatch.LogSubscriptionFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testLambdafunctionLogfilter = new LogSubscriptionFilter("testLambdafunctionLogfilter", LogSubscriptionFilterArgs.builder()
 *             .roleArn(aws_iam_role.iam_for_lambda().arn())
 *             .logGroup("/aws/lambda/example_lambda_name")
 *             .filterPattern("logtype test")
 *             .destinationArn(aws_kinesis_stream.test_logstream().arn())
 *             .distribution("Random")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Logs subscription filter using the log group name and subscription filter name separated by `|`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/logSubscriptionFilter:LogSubscriptionFilter test_lambdafunction_logfilter /aws/lambda/example_lambda_name|test_lambdafunction_logfilter
 * ```
 * @property destinationArn The ARN of the destination to deliver matching log events to. Kinesis stream or Lambda function ARN.
 * @property distribution The method used to distribute log data to the destination. By default log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. Valid values are "Random" and "ByLogStream".
 * @property filterPattern A valid CloudWatch Logs filter pattern for subscribing to a filtered stream of log events. Use empty string `""` to match everything. For more information, see the [Amazon CloudWatch Logs User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
 * @property logGroup The name of the log group to associate the subscription filter with
 * @property name A name for the subscription filter
 * @property roleArn The ARN of an IAM role that grants Amazon CloudWatch Logs permissions to deliver ingested log events to the destination. If you use Lambda as a destination, you should skip this argument and use `aws.lambda.Permission` resource for granting access from CloudWatch logs to the destination Lambda function.
 */
public data class LogSubscriptionFilterArgs(
    public val destinationArn: Output<String>? = null,
    public val distribution: Output<String>? = null,
    public val filterPattern: Output<String>? = null,
    public val logGroup: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.LogSubscriptionFilterArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.LogSubscriptionFilterArgs =
        com.pulumi.aws.cloudwatch.LogSubscriptionFilterArgs.builder()
            .destinationArn(destinationArn?.applyValue({ args0 -> args0 }))
            .distribution(distribution?.applyValue({ args0 -> args0 }))
            .filterPattern(filterPattern?.applyValue({ args0 -> args0 }))
            .logGroup(logGroup?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogSubscriptionFilterArgs].
 */
@PulumiTagMarker
public class LogSubscriptionFilterArgsBuilder internal constructor() {
    private var destinationArn: Output<String>? = null

    private var distribution: Output<String>? = null

    private var filterPattern: Output<String>? = null

    private var logGroup: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The ARN of the destination to deliver matching log events to. Kinesis stream or Lambda function ARN.
     */
    @JvmName("vbrtchgcjtkbngxc")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value The method used to distribute log data to the destination. By default log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. Valid values are "Random" and "ByLogStream".
     */
    @JvmName("yobbnuslidmxkshn")
    public suspend fun distribution(`value`: Output<String>) {
        this.distribution = value
    }

    /**
     * @param value A valid CloudWatch Logs filter pattern for subscribing to a filtered stream of log events. Use empty string `""` to match everything. For more information, see the [Amazon CloudWatch Logs User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
     */
    @JvmName("juouwwhwqgplipnf")
    public suspend fun filterPattern(`value`: Output<String>) {
        this.filterPattern = value
    }

    /**
     * @param value The name of the log group to associate the subscription filter with
     */
    @JvmName("glmifwfxlpmetgoc")
    public suspend fun logGroup(`value`: Output<String>) {
        this.logGroup = value
    }

    /**
     * @param value A name for the subscription filter
     */
    @JvmName("odlmapemqagteghm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of an IAM role that grants Amazon CloudWatch Logs permissions to deliver ingested log events to the destination. If you use Lambda as a destination, you should skip this argument and use `aws.lambda.Permission` resource for granting access from CloudWatch logs to the destination Lambda function.
     */
    @JvmName("dxhaxojnkdmleuwv")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the destination to deliver matching log events to. Kinesis stream or Lambda function ARN.
     */
    @JvmName("cwepjyuirldfdong")
    public suspend fun destinationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value The method used to distribute log data to the destination. By default log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. Valid values are "Random" and "ByLogStream".
     */
    @JvmName("hvqxjgfrmqbxpyqm")
    public suspend fun distribution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distribution = mapped
    }

    /**
     * @param value A valid CloudWatch Logs filter pattern for subscribing to a filtered stream of log events. Use empty string `""` to match everything. For more information, see the [Amazon CloudWatch Logs User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
     */
    @JvmName("lmfbjmeojosxvkth")
    public suspend fun filterPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPattern = mapped
    }

    /**
     * @param value The name of the log group to associate the subscription filter with
     */
    @JvmName("xbtapxkgdgkhfsqy")
    public suspend fun logGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroup = mapped
    }

    /**
     * @param value A name for the subscription filter
     */
    @JvmName("hhcuplpmeaexweym")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of an IAM role that grants Amazon CloudWatch Logs permissions to deliver ingested log events to the destination. If you use Lambda as a destination, you should skip this argument and use `aws.lambda.Permission` resource for granting access from CloudWatch logs to the destination Lambda function.
     */
    @JvmName("oasqmaituqrgglwp")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): LogSubscriptionFilterArgs = LogSubscriptionFilterArgs(
        destinationArn = destinationArn,
        distribution = distribution,
        filterPattern = filterPattern,
        logGroup = logGroup,
        name = name,
        roleArn = roleArn,
    )
}
