@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.kotlin.outputs.MetricStreamExcludeFilter
import com.pulumi.aws.cloudwatch.kotlin.outputs.MetricStreamIncludeFilter
import com.pulumi.aws.cloudwatch.kotlin.outputs.MetricStreamStatisticsConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudwatch.kotlin.outputs.MetricStreamExcludeFilter.Companion.toKotlin as metricStreamExcludeFilterToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.MetricStreamIncludeFilter.Companion.toKotlin as metricStreamIncludeFilterToKotlin
import com.pulumi.aws.cloudwatch.kotlin.outputs.MetricStreamStatisticsConfiguration.Companion.toKotlin as metricStreamStatisticsConfigurationToKotlin

/**
 * Builder for [MetricStream].
 */
@PulumiTagMarker
public class MetricStreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetricStreamArgs = MetricStreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetricStreamArgsBuilder.() -> Unit) {
        val builder = MetricStreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MetricStream {
        val builtJavaResource = com.pulumi.aws.cloudwatch.MetricStream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MetricStream(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Metric Stream resource.
 * ## Example Usage
 * ### Filters
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.cloudwatch.MetricStream;
 * import com.pulumi.aws.cloudwatch.MetricStreamArgs;
 * import com.pulumi.aws.cloudwatch.inputs.MetricStreamIncludeFilterArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var streamsAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("streams.metrics.cloudwatch.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var metricStreamToFirehoseRole = new Role("metricStreamToFirehoseRole", RoleArgs.builder()
 *             .assumeRolePolicy(streamsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var bucket = new BucketV2("bucket");
 *         final var firehoseAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var firehoseToS3Role = new Role("firehoseToS3Role", RoleArgs.builder()
 *             .assumeRolePolicy(firehoseAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var s3Stream = new FirehoseDeliveryStream("s3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseToS3Role.arn())
 *                 .bucketArn(bucket.arn())
 *                 .build())
 *             .build());
 *         var main = new MetricStream("main", MetricStreamArgs.builder()
 *             .roleArn(metricStreamToFirehoseRole.arn())
 *             .firehoseArn(s3Stream.arn())
 *             .outputFormat("json")
 *             .includeFilters(
 *                 MetricStreamIncludeFilterArgs.builder()
 *                     .namespace("AWS/EC2")
 *                     .metricNames(
 *                         "CPUUtilization",
 *                         "NetworkOut")
 *                     .build(),
 *                 MetricStreamIncludeFilterArgs.builder()
 *                     .namespace("AWS/EBS")
 *                     .metricNames()
 *                     .build())
 *             .build());
 *         final var metricStreamToFirehosePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "firehose:PutRecord",
 *                     "firehose:PutRecordBatch")
 *                 .resources(s3Stream.arn())
 *                 .build())
 *             .build());
 *         var metricStreamToFirehoseRolePolicy = new RolePolicy("metricStreamToFirehoseRolePolicy", RolePolicyArgs.builder()
 *             .role(metricStreamToFirehoseRole.id())
 *             .policy(metricStreamToFirehosePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(metricStreamToFirehosePolicyDocument -> metricStreamToFirehosePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *         final var firehoseToS3PolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "s3:AbortMultipartUpload",
 *                     "s3:GetBucketLocation",
 *                     "s3:GetObject",
 *                     "s3:ListBucket",
 *                     "s3:ListBucketMultipartUploads",
 *                     "s3:PutObject")
 *                 .resources(
 *                     bucket.arn(),
 *                     bucket.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .build())
 *             .build());
 *         var firehoseToS3RolePolicy = new RolePolicy("firehoseToS3RolePolicy", RolePolicyArgs.builder()
 *             .role(firehoseToS3Role.id())
 *             .policy(firehoseToS3PolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(firehoseToS3PolicyDocument -> firehoseToS3PolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Additional Statistics
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricStream;
 * import com.pulumi.aws.cloudwatch.MetricStreamArgs;
 * import com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new MetricStream("main", MetricStreamArgs.builder()
 *             .roleArn(aws_iam_role.metric_stream_to_firehose().arn())
 *             .firehoseArn(aws_kinesis_firehose_delivery_stream.s3_stream().arn())
 *             .outputFormat("json")
 *             .statisticsConfigurations(
 *                 MetricStreamStatisticsConfigurationArgs.builder()
 *                     .additionalStatistics(
 *                         "p1",
 *                         "tm99")
 *                     .includeMetrics(MetricStreamStatisticsConfigurationIncludeMetricArgs.builder()
 *                         .metricName("CPUUtilization")
 *                         .namespace("AWS/EC2")
 *                         .build())
 *                     .build(),
 *                 MetricStreamStatisticsConfigurationArgs.builder()
 *                     .additionalStatistics("TS(50.5:)")
 *                     .includeMetrics(MetricStreamStatisticsConfigurationIncludeMetricArgs.builder()
 *                         .metricName("CPUUtilization")
 *                         .namespace("AWS/EC2")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch metric streams using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/metricStream:MetricStream sample sample-stream-name
 * ```
 * */
 */
public class MetricStream internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.MetricStream,
) : KotlinCustomResource(javaResource, MetricStreamMapper) {
    /**
     * ARN of the metric stream.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the metric stream was created.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
     */
    public val excludeFilters: Output<List<MetricStreamExcludeFilter>>?
        get() = javaResource.excludeFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        metricStreamExcludeFilterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream.
     */
    public val firehoseArn: Output<String>
        get() = javaResource.firehoseArn().applyValue({ args0 -> args0 })

    /**
     * List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
     */
    public val includeFilters: Output<List<MetricStreamIncludeFilter>>?
        get() = javaResource.includeFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        metricStreamIncludeFilterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * If you are creating a metric stream in a monitoring account, specify true to include metrics from source accounts that are linked to this monitoring account, in the metric stream. The default is false. For more information about linking accounts, see [CloudWatch cross-account observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html).
     */
    public val includeLinkedAccountsMetrics: Output<Boolean>?
        get() = javaResource.includeLinkedAccountsMetrics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the metric stream was last updated.
     */
    public val lastUpdateDate: Output<String>
        get() = javaResource.lastUpdateDate().applyValue({ args0 -> args0 })

    /**
     * Friendly name of the metric stream. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Output format for the stream. Possible values are `json` and `opentelemetry0.7`. For more information about output formats, see [Metric streams output formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
     * The following arguments are optional:
     */
    public val outputFormat: Output<String>
        get() = javaResource.outputFormat().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. For more information about role permissions, see [Trust between CloudWatch and Kinesis Data Firehose](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-trustpolicy.html).
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * State of the metric stream. Possible values are `running` and `stopped`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
     */
    public val statisticsConfigurations: Output<List<MetricStreamStatisticsConfiguration>>?
        get() = javaResource.statisticsConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        metricStreamStatisticsConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MetricStreamMapper : ResourceMapper<MetricStream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.MetricStream::class == javaResource::class

    override fun map(javaResource: Resource): MetricStream = MetricStream(
        javaResource as
            com.pulumi.aws.cloudwatch.MetricStream,
    )
}

/**
 * @see [MetricStream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetricStream].
 */
public suspend fun metricStream(
    name: String,
    block: suspend MetricStreamResourceBuilder.() -> Unit,
): MetricStream {
    val builder = MetricStreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetricStream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metricStream(name: String): MetricStream {
    val builder = MetricStreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
