@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.MetricStreamArgs.builder
import com.pulumi.aws.cloudwatch.kotlin.inputs.MetricStreamExcludeFilterArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.MetricStreamExcludeFilterArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.MetricStreamIncludeFilterArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.MetricStreamIncludeFilterArgsBuilder
import com.pulumi.aws.cloudwatch.kotlin.inputs.MetricStreamStatisticsConfigurationArgs
import com.pulumi.aws.cloudwatch.kotlin.inputs.MetricStreamStatisticsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Metric Stream resource.
 * ## Example Usage
 * ### Filters
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.cloudwatch.MetricStream;
 * import com.pulumi.aws.cloudwatch.MetricStreamArgs;
 * import com.pulumi.aws.cloudwatch.inputs.MetricStreamIncludeFilterArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var streamsAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("streams.metrics.cloudwatch.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var metricStreamToFirehoseRole = new Role("metricStreamToFirehoseRole", RoleArgs.builder()
 *             .assumeRolePolicy(streamsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var bucket = new BucketV2("bucket");
 *         final var firehoseAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var firehoseToS3Role = new Role("firehoseToS3Role", RoleArgs.builder()
 *             .assumeRolePolicy(firehoseAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var s3Stream = new FirehoseDeliveryStream("s3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseToS3Role.arn())
 *                 .bucketArn(bucket.arn())
 *                 .build())
 *             .build());
 *         var main = new MetricStream("main", MetricStreamArgs.builder()
 *             .roleArn(metricStreamToFirehoseRole.arn())
 *             .firehoseArn(s3Stream.arn())
 *             .outputFormat("json")
 *             .includeFilters(
 *                 MetricStreamIncludeFilterArgs.builder()
 *                     .namespace("AWS/EC2")
 *                     .metricNames(
 *                         "CPUUtilization",
 *                         "NetworkOut")
 *                     .build(),
 *                 MetricStreamIncludeFilterArgs.builder()
 *                     .namespace("AWS/EBS")
 *                     .metricNames()
 *                     .build())
 *             .build());
 *         final var metricStreamToFirehosePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "firehose:PutRecord",
 *                     "firehose:PutRecordBatch")
 *                 .resources(s3Stream.arn())
 *                 .build())
 *             .build());
 *         var metricStreamToFirehoseRolePolicy = new RolePolicy("metricStreamToFirehoseRolePolicy", RolePolicyArgs.builder()
 *             .role(metricStreamToFirehoseRole.id())
 *             .policy(metricStreamToFirehosePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(metricStreamToFirehosePolicyDocument -> metricStreamToFirehosePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *         final var firehoseToS3PolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "s3:AbortMultipartUpload",
 *                     "s3:GetBucketLocation",
 *                     "s3:GetObject",
 *                     "s3:ListBucket",
 *                     "s3:ListBucketMultipartUploads",
 *                     "s3:PutObject")
 *                 .resources(
 *                     bucket.arn(),
 *                     bucket.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .build())
 *             .build());
 *         var firehoseToS3RolePolicy = new RolePolicy("firehoseToS3RolePolicy", RolePolicyArgs.builder()
 *             .role(firehoseToS3Role.id())
 *             .policy(firehoseToS3PolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(firehoseToS3PolicyDocument -> firehoseToS3PolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Additional Statistics
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricStream;
 * import com.pulumi.aws.cloudwatch.MetricStreamArgs;
 * import com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new MetricStream("main", MetricStreamArgs.builder()
 *             .roleArn(aws_iam_role.metric_stream_to_firehose().arn())
 *             .firehoseArn(aws_kinesis_firehose_delivery_stream.s3_stream().arn())
 *             .outputFormat("json")
 *             .statisticsConfigurations(
 *                 MetricStreamStatisticsConfigurationArgs.builder()
 *                     .additionalStatistics(
 *                         "p1",
 *                         "tm99")
 *                     .includeMetrics(MetricStreamStatisticsConfigurationIncludeMetricArgs.builder()
 *                         .metricName("CPUUtilization")
 *                         .namespace("AWS/EC2")
 *                         .build())
 *                     .build(),
 *                 MetricStreamStatisticsConfigurationArgs.builder()
 *                     .additionalStatistics("TS(50.5:)")
 *                     .includeMetrics(MetricStreamStatisticsConfigurationIncludeMetricArgs.builder()
 *                         .metricName("CPUUtilization")
 *                         .namespace("AWS/EC2")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch metric streams using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/metricStream:MetricStream sample sample-stream-name
 * ```
 * @property excludeFilters List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
 * @property firehoseArn ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream.
 * @property includeFilters List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
 * @property includeLinkedAccountsMetrics If you are creating a metric stream in a monitoring account, specify true to include metrics from source accounts that are linked to this monitoring account, in the metric stream. The default is false. For more information about linking accounts, see [CloudWatch cross-account observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html).
 * @property name Friendly name of the metric stream. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
 * @property outputFormat Output format for the stream. Possible values are `json` and `opentelemetry0.7`. For more information about output formats, see [Metric streams output formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
 * The following arguments are optional:
 * @property roleArn ARN of the IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. For more information about role permissions, see [Trust between CloudWatch and Kinesis Data Firehose](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-trustpolicy.html).
 * @property statisticsConfigurations For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * */
 */
public data class MetricStreamArgs(
    public val excludeFilters: Output<List<MetricStreamExcludeFilterArgs>>? = null,
    public val firehoseArn: Output<String>? = null,
    public val includeFilters: Output<List<MetricStreamIncludeFilterArgs>>? = null,
    public val includeLinkedAccountsMetrics: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val outputFormat: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val statisticsConfigurations: Output<List<MetricStreamStatisticsConfigurationArgs>>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.MetricStreamArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.MetricStreamArgs =
        com.pulumi.aws.cloudwatch.MetricStreamArgs.builder()
            .excludeFilters(
                excludeFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .firehoseArn(firehoseArn?.applyValue({ args0 -> args0 }))
            .includeFilters(
                includeFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .includeLinkedAccountsMetrics(includeLinkedAccountsMetrics?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .outputFormat(outputFormat?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .statisticsConfigurations(
                statisticsConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MetricStreamArgs].
 */
@PulumiTagMarker
public class MetricStreamArgsBuilder internal constructor() {
    private var excludeFilters: Output<List<MetricStreamExcludeFilterArgs>>? = null

    private var firehoseArn: Output<String>? = null

    private var includeFilters: Output<List<MetricStreamIncludeFilterArgs>>? = null

    private var includeLinkedAccountsMetrics: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var outputFormat: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var statisticsConfigurations: Output<List<MetricStreamStatisticsConfigurationArgs>>? =
        null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
     */
    @JvmName("sdfvnsdrquqgeboe")
    public suspend fun excludeFilters(`value`: Output<List<MetricStreamExcludeFilterArgs>>) {
        this.excludeFilters = value
    }

    @JvmName("sndaneutgtsyaoyx")
    public suspend fun excludeFilters(vararg values: Output<MetricStreamExcludeFilterArgs>) {
        this.excludeFilters = Output.all(values.asList())
    }

    /**
     * @param values List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
     */
    @JvmName("xcsbnqqvjdmleotd")
    public suspend fun excludeFilters(values: List<Output<MetricStreamExcludeFilterArgs>>) {
        this.excludeFilters = Output.all(values)
    }

    /**
     * @param value ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream.
     */
    @JvmName("acdfnpwcksgiqdkx")
    public suspend fun firehoseArn(`value`: Output<String>) {
        this.firehoseArn = value
    }

    /**
     * @param value List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
     */
    @JvmName("bgnkwnjxvhjrxkwo")
    public suspend fun includeFilters(`value`: Output<List<MetricStreamIncludeFilterArgs>>) {
        this.includeFilters = value
    }

    @JvmName("ffqwukbtjpaqoivy")
    public suspend fun includeFilters(vararg values: Output<MetricStreamIncludeFilterArgs>) {
        this.includeFilters = Output.all(values.asList())
    }

    /**
     * @param values List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
     */
    @JvmName("uouajfxucwxaxlyg")
    public suspend fun includeFilters(values: List<Output<MetricStreamIncludeFilterArgs>>) {
        this.includeFilters = Output.all(values)
    }

    /**
     * @param value If you are creating a metric stream in a monitoring account, specify true to include metrics from source accounts that are linked to this monitoring account, in the metric stream. The default is false. For more information about linking accounts, see [CloudWatch cross-account observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html).
     */
    @JvmName("spcrmbsnsydbbkwb")
    public suspend fun includeLinkedAccountsMetrics(`value`: Output<Boolean>) {
        this.includeLinkedAccountsMetrics = value
    }

    /**
     * @param value Friendly name of the metric stream. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("txlsthbeusskpsnx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("xwmltwosnmdbvntf")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Output format for the stream. Possible values are `json` and `opentelemetry0.7`. For more information about output formats, see [Metric streams output formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
     * The following arguments are optional:
     */
    @JvmName("mmqqvgwcbiefafqv")
    public suspend fun outputFormat(`value`: Output<String>) {
        this.outputFormat = value
    }

    /**
     * @param value ARN of the IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. For more information about role permissions, see [Trust between CloudWatch and Kinesis Data Firehose](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-trustpolicy.html).
     */
    @JvmName("tvvidbrlsamcvuil")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
     */
    @JvmName("xvrgyxkaubsaxafj")
    public suspend
    fun statisticsConfigurations(`value`: Output<List<MetricStreamStatisticsConfigurationArgs>>) {
        this.statisticsConfigurations = value
    }

    @JvmName("mhkmrjhdeofuggnt")
    public suspend fun statisticsConfigurations(
        vararg
        values: Output<MetricStreamStatisticsConfigurationArgs>,
    ) {
        this.statisticsConfigurations = Output.all(values.asList())
    }

    /**
     * @param values For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
     */
    @JvmName("lkmktxfhsphwiapg")
    public suspend
    fun statisticsConfigurations(values: List<Output<MetricStreamStatisticsConfigurationArgs>>) {
        this.statisticsConfigurations = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lhxxmviafwgouyfh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
     */
    @JvmName("wttbvcmukmcptdji")
    public suspend fun excludeFilters(`value`: List<MetricStreamExcludeFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeFilters = mapped
    }

    /**
     * @param argument List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
     */
    @JvmName("kdkjaxqkpaohhsya")
    public suspend
    fun excludeFilters(argument: List<suspend MetricStreamExcludeFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricStreamExcludeFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.excludeFilters = mapped
    }

    /**
     * @param argument List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
     */
    @JvmName("euljocpwvcgxdimg")
    public suspend fun excludeFilters(
        vararg
        argument: suspend MetricStreamExcludeFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MetricStreamExcludeFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.excludeFilters = mapped
    }

    /**
     * @param argument List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
     */
    @JvmName("rbjtwmqujgnqxpoi")
    public suspend
    fun excludeFilters(argument: suspend MetricStreamExcludeFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MetricStreamExcludeFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.excludeFilters = mapped
    }

    /**
     * @param values List of exclusive metric filters. If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces and the conditional metric names that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is excluded. Conflicts with `include_filter`.
     */
    @JvmName("txlfbwrwlwwkqhui")
    public suspend fun excludeFilters(vararg values: MetricStreamExcludeFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludeFilters = mapped
    }

    /**
     * @param value ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream.
     */
    @JvmName("dblurrwmihprpjof")
    public suspend fun firehoseArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehoseArn = mapped
    }

    /**
     * @param value List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
     */
    @JvmName("mmgehrpldsvpeewf")
    public suspend fun includeFilters(`value`: List<MetricStreamIncludeFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeFilters = mapped
    }

    /**
     * @param argument List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
     */
    @JvmName("extjbebbkdckekwd")
    public suspend
    fun includeFilters(argument: List<suspend MetricStreamIncludeFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricStreamIncludeFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.includeFilters = mapped
    }

    /**
     * @param argument List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
     */
    @JvmName("dafcnumogkdemous")
    public suspend fun includeFilters(
        vararg
        argument: suspend MetricStreamIncludeFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MetricStreamIncludeFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.includeFilters = mapped
    }

    /**
     * @param argument List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
     */
    @JvmName("bdgynfjlcdqbgbjn")
    public suspend
    fun includeFilters(argument: suspend MetricStreamIncludeFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MetricStreamIncludeFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.includeFilters = mapped
    }

    /**
     * @param values List of inclusive metric filters. If you specify this parameter, the stream sends only the conditional metric names from the metric namespaces that you specify here. If you don't specify metric names or provide empty metric names whole metric namespace is included. Conflicts with `exclude_filter`.
     */
    @JvmName("axsqoncqrgycooiy")
    public suspend fun includeFilters(vararg values: MetricStreamIncludeFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includeFilters = mapped
    }

    /**
     * @param value If you are creating a metric stream in a monitoring account, specify true to include metrics from source accounts that are linked to this monitoring account, in the metric stream. The default is false. For more information about linking accounts, see [CloudWatch cross-account observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html).
     */
    @JvmName("oniwhaguqqvsvjfi")
    public suspend fun includeLinkedAccountsMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeLinkedAccountsMetrics = mapped
    }

    /**
     * @param value Friendly name of the metric stream. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("aidpwrqptwerryep")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("bfgnvsabmjubnjtm")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Output format for the stream. Possible values are `json` and `opentelemetry0.7`. For more information about output formats, see [Metric streams output formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
     * The following arguments are optional:
     */
    @JvmName("akklldrkddayijwf")
    public suspend fun outputFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputFormat = mapped
    }

    /**
     * @param value ARN of the IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. For more information about role permissions, see [Trust between CloudWatch and Kinesis Data Firehose](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-trustpolicy.html).
     */
    @JvmName("dsadpyqplflexutt")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
     */
    @JvmName("phgsycebfnljbhwb")
    public suspend
    fun statisticsConfigurations(`value`: List<MetricStreamStatisticsConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statisticsConfigurations = mapped
    }

    /**
     * @param argument For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
     */
    @JvmName("wxfepungqljjfwgg")
    public suspend
    fun statisticsConfigurations(argument: List<suspend MetricStreamStatisticsConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricStreamStatisticsConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statisticsConfigurations = mapped
    }

    /**
     * @param argument For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
     */
    @JvmName("samkfrlupkjjriih")
    public suspend fun statisticsConfigurations(
        vararg
        argument: suspend MetricStreamStatisticsConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MetricStreamStatisticsConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statisticsConfigurations = mapped
    }

    /**
     * @param argument For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
     */
    @JvmName("mdixtncconltlpni")
    public suspend
    fun statisticsConfigurations(argument: suspend MetricStreamStatisticsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MetricStreamStatisticsConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.statisticsConfigurations = mapped
    }

    /**
     * @param values For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `output_format`. If the OutputFormat is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the OutputFormat is `opentelemetry0.7`, you can stream percentile statistics (p99 etc.). See details below.
     */
    @JvmName("bqtkryrleisycwsh")
    public suspend fun statisticsConfigurations(
        vararg
        values: MetricStreamStatisticsConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statisticsConfigurations = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("niiygfqfaicvhhip")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fjgblrsegrpdjulm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MetricStreamArgs = MetricStreamArgs(
        excludeFilters = excludeFilters,
        firehoseArn = firehoseArn,
        includeFilters = includeFilters,
        includeLinkedAccountsMetrics = includeLinkedAccountsMetrics,
        name = name,
        namePrefix = namePrefix,
        outputFormat = outputFormat,
        roleArn = roleArn,
        statisticsConfigurations = statisticsConfigurations,
        tags = tags,
    )
}
