@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [QueryDefinition].
 */
@PulumiTagMarker
public class QueryDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueryDefinitionArgs = QueryDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueryDefinitionArgsBuilder.() -> Unit) {
        val builder = QueryDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): QueryDefinition {
        val builtJavaResource = com.pulumi.aws.cloudwatch.QueryDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QueryDefinition(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Logs query definition resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.QueryDefinition;
 * import com.pulumi.aws.cloudwatch.QueryDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new QueryDefinition("example", QueryDefinitionArgs.builder()
 *             .logGroupNames(
 *                 "/aws/logGroup1",
 *                 "/aws/logGroup2")
 *             .queryString("""
 * fields @timestamp, @message
 * | sort @timestamp desc
 * | limit 25
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch query definitions using the query definition ARN. The ARN can be found on the "Edit Query" page for the query in the AWS Console. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/queryDefinition:QueryDefinition example arn:aws:logs:us-west-2:123456789012:query-definition:269951d7-6f75-496d-9d7b-6b7a5486bdbd
 * ```
 *
 */
public class QueryDefinition internal constructor(
    override val javaResource: com.pulumi.aws.cloudwatch.QueryDefinition,
) : KotlinCustomResource(javaResource, QueryDefinitionMapper) {
    /**
     * Specific log groups to use with the query.
     */
    public val logGroupNames: Output<List<String>>?
        get() = javaResource.logGroupNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the query.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The query definition ID.
     */
    public val queryDefinitionId: Output<String>
        get() = javaResource.queryDefinitionId().applyValue({ args0 -> args0 })

    /**
     * The query to save. You can read more about CloudWatch Logs Query Syntax in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
     */
    public val queryString: Output<String>
        get() = javaResource.queryString().applyValue({ args0 -> args0 })
}

public object QueryDefinitionMapper : ResourceMapper<QueryDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudwatch.QueryDefinition::class == javaResource::class

    override fun map(javaResource: Resource): QueryDefinition = QueryDefinition(
        javaResource as
            com.pulumi.aws.cloudwatch.QueryDefinition,
    )
}

/**
 * @see [QueryDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QueryDefinition].
 */
public suspend fun queryDefinition(
    name: String,
    block: suspend QueryDefinitionResourceBuilder.() -> Unit,
): QueryDefinition {
    val builder = QueryDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QueryDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queryDefinition(name: String): QueryDefinition {
    val builder = QueryDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
