@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin

import com.pulumi.aws.cloudwatch.QueryDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Logs query definition resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.QueryDefinition;
 * import com.pulumi.aws.cloudwatch.QueryDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new QueryDefinition("example", QueryDefinitionArgs.builder()
 *             .logGroupNames(
 *                 "/aws/logGroup1",
 *                 "/aws/logGroup2")
 *             .queryString("""
 * fields @timestamp, @message
 * | sort @timestamp desc
 * | limit 25
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch query definitions using the query definition ARN. The ARN can be found on the "Edit Query" page for the query in the AWS Console. For example:
 * ```sh
 *  $ pulumi import aws:cloudwatch/queryDefinition:QueryDefinition example arn:aws:logs:us-west-2:123456789012:query-definition:269951d7-6f75-496d-9d7b-6b7a5486bdbd
 * ```
 * @property logGroupNames Specific log groups to use with the query.
 * @property name The name of the query.
 * @property queryString The query to save. You can read more about CloudWatch Logs Query Syntax in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
 */
public data class QueryDefinitionArgs(
    public val logGroupNames: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val queryString: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.QueryDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.QueryDefinitionArgs =
        com.pulumi.aws.cloudwatch.QueryDefinitionArgs.builder()
            .logGroupNames(logGroupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .queryString(queryString?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueryDefinitionArgs].
 */
@PulumiTagMarker
public class QueryDefinitionArgsBuilder internal constructor() {
    private var logGroupNames: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var queryString: Output<String>? = null

    /**
     * @param value Specific log groups to use with the query.
     */
    @JvmName("gerdfbutsjvxgfhm")
    public suspend fun logGroupNames(`value`: Output<List<String>>) {
        this.logGroupNames = value
    }

    @JvmName("pywaktwpfndaertx")
    public suspend fun logGroupNames(vararg values: Output<String>) {
        this.logGroupNames = Output.all(values.asList())
    }

    /**
     * @param values Specific log groups to use with the query.
     */
    @JvmName("hnnvkvfsciptaoox")
    public suspend fun logGroupNames(values: List<Output<String>>) {
        this.logGroupNames = Output.all(values)
    }

    /**
     * @param value The name of the query.
     */
    @JvmName("pyurqwtvrkbupfij")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The query to save. You can read more about CloudWatch Logs Query Syntax in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
     */
    @JvmName("dfkhitynjwlealte")
    public suspend fun queryString(`value`: Output<String>) {
        this.queryString = value
    }

    /**
     * @param value Specific log groups to use with the query.
     */
    @JvmName("kfxtycekpnxyshfx")
    public suspend fun logGroupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupNames = mapped
    }

    /**
     * @param values Specific log groups to use with the query.
     */
    @JvmName("corxoqushueghiue")
    public suspend fun logGroupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupNames = mapped
    }

    /**
     * @param value The name of the query.
     */
    @JvmName("rikvmfkaguwodcmr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The query to save. You can read more about CloudWatch Logs Query Syntax in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
     */
    @JvmName("ypclqfvorsiocnnp")
    public suspend fun queryString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    internal fun build(): QueryDefinitionArgs = QueryDefinitionArgs(
        logGroupNames = logGroupNames,
        name = name,
        queryString = queryString,
    )
}
