@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersBodyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property isValueSecret Specified whether the value is secret.
 * @property key Header Name.
 * @property value Header Value. Created and stored in AWS Secrets Manager.
 */
public data class EventConnectionAuthParametersInvocationHttpParametersBodyArgs(
    public val isValueSecret: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersBodyArgs> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersBodyArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersInvocationHttpParametersBodyArgs.builder()
            .isValueSecret(isValueSecret?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventConnectionAuthParametersInvocationHttpParametersBodyArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersInvocationHttpParametersBodyArgsBuilder internal
constructor() {
    private var isValueSecret: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Specified whether the value is secret.
     */
    @JvmName("gursdlchxolsmyri")
    public suspend fun isValueSecret(`value`: Output<Boolean>) {
        this.isValueSecret = value
    }

    /**
     * @param value Header Name.
     */
    @JvmName("ogiswjrhholiueml")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Header Value. Created and stored in AWS Secrets Manager.
     */
    @JvmName("scifspshlwjewiqr")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Specified whether the value is secret.
     */
    @JvmName("fvpsbyvpdcqqubxs")
    public suspend fun isValueSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isValueSecret = mapped
    }

    /**
     * @param value Header Name.
     */
    @JvmName("onsxafcqvvvlnchh")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Header Value. Created and stored in AWS Secrets Manager.
     */
    @JvmName("frctnmmfgsbwxuvw")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EventConnectionAuthParametersInvocationHttpParametersBodyArgs =
        EventConnectionAuthParametersInvocationHttpParametersBodyArgs(
            isValueSecret = isValueSecret,
            key = key,
            `value` = `value`,
        )
}
