@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bodies Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 * @property headers Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 * @property queryStrings Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 */
public data class EventConnectionAuthParametersOauthOauthHttpParametersArgs(
    public val bodies: Output<List<EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs>>? =
        null,
    public val headers: Output<List<EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs>>? =
        null,
    public val queryStrings:
    Output<List<EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs =
        com.pulumi.aws.cloudwatch.inputs.EventConnectionAuthParametersOauthOauthHttpParametersArgs.builder()
            .bodies(bodies?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .queryStrings(
                queryStrings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventConnectionAuthParametersOauthOauthHttpParametersArgs].
 */
@PulumiTagMarker
public class EventConnectionAuthParametersOauthOauthHttpParametersArgsBuilder internal constructor() {
    private var bodies: Output<List<EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs>>? =
        null

    private var headers:
        Output<List<EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs>>? = null

    private var queryStrings:
        Output<List<EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs>>? = null

    /**
     * @param value Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("ttbpaqfdxhdykwyh")
    public suspend
    fun bodies(`value`: Output<List<EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs>>) {
        this.bodies = value
    }

    @JvmName("ipnpbvbgqhtiycux")
    public suspend fun bodies(
        vararg
        values: Output<EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs>,
    ) {
        this.bodies = Output.all(values.asList())
    }

    /**
     * @param values Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("ydxyrjygdnvkcqgh")
    public suspend
    fun bodies(values: List<Output<EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs>>) {
        this.bodies = Output.all(values)
    }

    /**
     * @param value Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("nexlsxdrqlmlyuhf")
    public suspend
    fun headers(`value`: Output<List<EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("ucncmhglaisvocod")
    public suspend fun headers(
        vararg
        values: Output<EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("fqaxdkggsabvuqjy")
    public suspend
    fun headers(values: List<Output<EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("sajjvnkuptrusovs")
    public suspend
    fun queryStrings(`value`: Output<List<EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs>>) {
        this.queryStrings = value
    }

    @JvmName("embtuxyupugbwanj")
    public suspend fun queryStrings(
        vararg
        values: Output<EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs>,
    ) {
        this.queryStrings = Output.all(values.asList())
    }

    /**
     * @param values Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("hawelaftbekwkdxr")
    public suspend
    fun queryStrings(values: List<Output<EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs>>) {
        this.queryStrings = Output.all(values)
    }

    /**
     * @param value Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("wuftxuttlseoajgd")
    public suspend
    fun bodies(`value`: List<EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bodies = mapped
    }

    /**
     * @param argument Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("oarnnmdngdlfkwjr")
    public suspend
    fun bodies(argument: List<suspend EventConnectionAuthParametersOauthOauthHttpParametersBodyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersOauthOauthHttpParametersBodyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bodies = mapped
    }

    /**
     * @param argument Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("nncsecdbgwllowpl")
    public suspend fun bodies(
        vararg
        argument: suspend EventConnectionAuthParametersOauthOauthHttpParametersBodyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersOauthOauthHttpParametersBodyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bodies = mapped
    }

    /**
     * @param argument Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("pfclxolsokexumeu")
    public suspend
    fun bodies(argument: suspend EventConnectionAuthParametersOauthOauthHttpParametersBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventConnectionAuthParametersOauthOauthHttpParametersBodyArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.bodies = mapped
    }

    /**
     * @param values Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("rpvwbemgaxorpgqk")
    public suspend fun bodies(
        vararg
        values: EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bodies = mapped
    }

    /**
     * @param value Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("oamyrhmksmcrpsby")
    public suspend
    fun headers(`value`: List<EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("olkgcxmbsgowtavt")
    public suspend
    fun headers(argument: List<suspend EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("tsleodgplojjqjah")
    public suspend fun headers(
        vararg
        argument: suspend EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("wdldnpbrhuqldjvc")
    public suspend
    fun headers(argument: suspend EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("jrbsdpslnwtfqbeq")
    public suspend fun headers(
        vararg
        values: EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("lnhabaaodkyqodod")
    public suspend
    fun queryStrings(`value`: List<EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStrings = mapped
    }

    /**
     * @param argument Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("crijvqcwkfctycci")
    public suspend
    fun queryStrings(argument: List<suspend EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param argument Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("eqmbkdtshhunufxp")
    public suspend fun queryStrings(
        vararg
        argument: suspend EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param argument Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("lxdqplldtattppbb")
    public suspend
    fun queryStrings(argument: suspend EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param values Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
     */
    @JvmName("hrtxdctasjuxdicy")
    public suspend fun queryStrings(
        vararg
        values: EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStrings = mapped
    }

    internal fun build(): EventConnectionAuthParametersOauthOauthHttpParametersArgs =
        EventConnectionAuthParametersOauthOauthHttpParametersArgs(
            bodies = bodies,
            headers = headers,
            queryStrings = queryStrings,
        )
}
