@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventEndpointEventBusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventBusArn The ARN of the event bus the endpoint is associated with.
 */
public data class EventEndpointEventBusArgs(
    public val eventBusArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventEndpointEventBusArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventEndpointEventBusArgs =
        com.pulumi.aws.cloudwatch.inputs.EventEndpointEventBusArgs.builder()
            .eventBusArn(eventBusArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventEndpointEventBusArgs].
 */
@PulumiTagMarker
public class EventEndpointEventBusArgsBuilder internal constructor() {
    private var eventBusArn: Output<String>? = null

    /**
     * @param value The ARN of the event bus the endpoint is associated with.
     */
    @JvmName("wyccfduphgjkyqgy")
    public suspend fun eventBusArn(`value`: Output<String>) {
        this.eventBusArn = value
    }

    /**
     * @param value The ARN of the event bus the endpoint is associated with.
     */
    @JvmName("oiihixalipqreumk")
    public suspend fun eventBusArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventBusArn = mapped
    }

    internal fun build(): EventEndpointEventBusArgs = EventEndpointEventBusArgs(
        eventBusArn = eventBusArn ?: throw PulumiNullFieldException("eventBusArn"),
    )
}
