@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventEndpointReplicationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property state The state of event replication. Valid values: `ENABLED`, `DISABLED`. The default state is `ENABLED`, which means you must supply a `role_arn`. If you don't have a `role_arn` or you don't want event replication enabled, set `state` to `DISABLED`.
 */
public data class EventEndpointReplicationConfigArgs(
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventEndpointReplicationConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventEndpointReplicationConfigArgs =
        com.pulumi.aws.cloudwatch.inputs.EventEndpointReplicationConfigArgs.builder()
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventEndpointReplicationConfigArgs].
 */
@PulumiTagMarker
public class EventEndpointReplicationConfigArgsBuilder internal constructor() {
    private var state: Output<String>? = null

    /**
     * @param value The state of event replication. Valid values: `ENABLED`, `DISABLED`. The default state is `ENABLED`, which means you must supply a `role_arn`. If you don't have a `role_arn` or you don't want event replication enabled, set `state` to `DISABLED`.
     */
    @JvmName("jiosrjlrcmrktxid")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The state of event replication. Valid values: `ENABLED`, `DISABLED`. The default state is `ENABLED`, which means you must supply a `role_arn`. If you don't have a `role_arn` or you don't want event replication enabled, set `state` to `DISABLED`.
     */
    @JvmName("omypcutojcvkdxjv")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): EventEndpointReplicationConfigArgs = EventEndpointReplicationConfigArgs(
        state = state,
    )
}
