@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property failoverConfig Parameters used for failover. This includes what triggers failover and what happens when it's triggered. Documented below.
 */
public data class EventEndpointRoutingConfigArgs(
    public val failoverConfig: Output<EventEndpointRoutingConfigFailoverConfigArgs>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigArgs =
        com.pulumi.aws.cloudwatch.inputs.EventEndpointRoutingConfigArgs.builder()
            .failoverConfig(
                failoverConfig.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EventEndpointRoutingConfigArgs].
 */
@PulumiTagMarker
public class EventEndpointRoutingConfigArgsBuilder internal constructor() {
    private var failoverConfig: Output<EventEndpointRoutingConfigFailoverConfigArgs>? = null

    /**
     * @param value Parameters used for failover. This includes what triggers failover and what happens when it's triggered. Documented below.
     */
    @JvmName("oahylpucmjcyyxjn")
    public suspend fun failoverConfig(`value`: Output<EventEndpointRoutingConfigFailoverConfigArgs>) {
        this.failoverConfig = value
    }

    /**
     * @param value Parameters used for failover. This includes what triggers failover and what happens when it's triggered. Documented below.
     */
    @JvmName("kinrmhrixyynkheo")
    public suspend fun failoverConfig(`value`: EventEndpointRoutingConfigFailoverConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverConfig = mapped
    }

    /**
     * @param argument Parameters used for failover. This includes what triggers failover and what happens when it's triggered. Documented below.
     */
    @JvmName("kekpocvbinskkaph")
    public suspend
    fun failoverConfig(argument: suspend EventEndpointRoutingConfigFailoverConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EventEndpointRoutingConfigFailoverConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.failoverConfig = mapped
    }

    internal fun build(): EventEndpointRoutingConfigArgs = EventEndpointRoutingConfigArgs(
        failoverConfig = failoverConfig ?: throw PulumiNullFieldException("failoverConfig"),
    )
}
