@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetBatchTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arraySize The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
 * @property jobAttempts The number of times to attempt to retry, if the job fails. Valid values are 1 to 10.
 * @property jobDefinition The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
 * @property jobName The name to use for this execution of the job, if the target is an AWS Batch job.
 */
public data class EventTargetBatchTargetArgs(
    public val arraySize: Output<Int>? = null,
    public val jobAttempts: Output<Int>? = null,
    public val jobDefinition: Output<String>,
    public val jobName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetBatchTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetBatchTargetArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetBatchTargetArgs.builder()
            .arraySize(arraySize?.applyValue({ args0 -> args0 }))
            .jobAttempts(jobAttempts?.applyValue({ args0 -> args0 }))
            .jobDefinition(jobDefinition.applyValue({ args0 -> args0 }))
            .jobName(jobName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetBatchTargetArgs].
 */
@PulumiTagMarker
public class EventTargetBatchTargetArgsBuilder internal constructor() {
    private var arraySize: Output<Int>? = null

    private var jobAttempts: Output<Int>? = null

    private var jobDefinition: Output<String>? = null

    private var jobName: Output<String>? = null

    /**
     * @param value The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
     */
    @JvmName("ypctygapvnggeaes")
    public suspend fun arraySize(`value`: Output<Int>) {
        this.arraySize = value
    }

    /**
     * @param value The number of times to attempt to retry, if the job fails. Valid values are 1 to 10.
     */
    @JvmName("hwnolmjbiyfppqff")
    public suspend fun jobAttempts(`value`: Output<Int>) {
        this.jobAttempts = value
    }

    /**
     * @param value The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
     */
    @JvmName("trsgggsosvnanwnk")
    public suspend fun jobDefinition(`value`: Output<String>) {
        this.jobDefinition = value
    }

    /**
     * @param value The name to use for this execution of the job, if the target is an AWS Batch job.
     */
    @JvmName("unncjygyhswofgry")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
     */
    @JvmName("xccognwdcvsdefee")
    public suspend fun arraySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arraySize = mapped
    }

    /**
     * @param value The number of times to attempt to retry, if the job fails. Valid values are 1 to 10.
     */
    @JvmName("pctppkxxbkeeesjg")
    public suspend fun jobAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobAttempts = mapped
    }

    /**
     * @param value The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
     */
    @JvmName("dojwcntbolmhuywk")
    public suspend fun jobDefinition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobDefinition = mapped
    }

    /**
     * @param value The name to use for this execution of the job, if the target is an AWS Batch job.
     */
    @JvmName("agjxyrwqmwsdpttg")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    internal fun build(): EventTargetBatchTargetArgs = EventTargetBatchTargetArgs(
        arraySize = arraySize,
        jobAttempts = jobAttempts,
        jobDefinition = jobDefinition ?: throw PulumiNullFieldException("jobDefinition"),
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
    )
}
