@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property capacityProviderStrategies The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
 * @property enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task.
 * @property enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
 * @property group Specifies an ECS task group for the task. The maximum length is 255 characters.
 * @property launchType Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. Valid values include: `EC2`, `EXTERNAL`, or `FARGATE`.
 * @property networkConfiguration Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
 * @property orderedPlacementStrategies An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
 * @property placementConstraints An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
 * @property platformVersion Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`. This is used only if LaunchType is FARGATE. For more information about valid platform versions, see [AWS Fargate Platform Versions](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
 * @property propagateTags Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. The only valid value is: `TASK_DEFINITION`.
 * @property tags A map of tags to assign to ecs resources.
 * @property taskCount The number of tasks to create based on the TaskDefinition. Defaults to `1`.
 * @property taskDefinitionArn The ARN of the task definition to use if the event target is an Amazon ECS cluster.
 */
public data class EventTargetEcsTargetArgs(
    public val capacityProviderStrategies:
    Output<List<EventTargetEcsTargetCapacityProviderStrategyArgs>>? = null,
    public val enableEcsManagedTags: Output<Boolean>? = null,
    public val enableExecuteCommand: Output<Boolean>? = null,
    public val group: Output<String>? = null,
    public val launchType: Output<String>? = null,
    public val networkConfiguration: Output<EventTargetEcsTargetNetworkConfigurationArgs>? = null,
    public val orderedPlacementStrategies:
    Output<List<EventTargetEcsTargetOrderedPlacementStrategyArgs>>? = null,
    public val placementConstraints: Output<List<EventTargetEcsTargetPlacementConstraintArgs>>? =
        null,
    public val platformVersion: Output<String>? = null,
    public val propagateTags: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskCount: Output<Int>? = null,
    public val taskDefinitionArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetArgs.builder()
            .capacityProviderStrategies(
                capacityProviderStrategies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableEcsManagedTags(enableEcsManagedTags?.applyValue({ args0 -> args0 }))
            .enableExecuteCommand(enableExecuteCommand?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .launchType(launchType?.applyValue({ args0 -> args0 }))
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .orderedPlacementStrategies(
                orderedPlacementStrategies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .placementConstraints(
                placementConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .platformVersion(platformVersion?.applyValue({ args0 -> args0 }))
            .propagateTags(propagateTags?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taskCount(taskCount?.applyValue({ args0 -> args0 }))
            .taskDefinitionArn(taskDefinitionArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetEcsTargetArgs].
 */
@PulumiTagMarker
public class EventTargetEcsTargetArgsBuilder internal constructor() {
    private var capacityProviderStrategies:
        Output<List<EventTargetEcsTargetCapacityProviderStrategyArgs>>? = null

    private var enableEcsManagedTags: Output<Boolean>? = null

    private var enableExecuteCommand: Output<Boolean>? = null

    private var group: Output<String>? = null

    private var launchType: Output<String>? = null

    private var networkConfiguration: Output<EventTargetEcsTargetNetworkConfigurationArgs>? = null

    private var orderedPlacementStrategies:
        Output<List<EventTargetEcsTargetOrderedPlacementStrategyArgs>>? = null

    private var placementConstraints: Output<List<EventTargetEcsTargetPlacementConstraintArgs>>? =
        null

    private var platformVersion: Output<String>? = null

    private var propagateTags: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskCount: Output<Int>? = null

    private var taskDefinitionArn: Output<String>? = null

    /**
     * @param value The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
     */
    @JvmName("ywtqhtowbisadttt")
    public suspend
    fun capacityProviderStrategies(`value`: Output<List<EventTargetEcsTargetCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = value
    }

    @JvmName("rdqgleedxfvkyvxp")
    public suspend fun capacityProviderStrategies(
        vararg
        values: Output<EventTargetEcsTargetCapacityProviderStrategyArgs>,
    ) {
        this.capacityProviderStrategies = Output.all(values.asList())
    }

    /**
     * @param values The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
     */
    @JvmName("vuhcwiyqcholhlab")
    public suspend
    fun capacityProviderStrategies(values: List<Output<EventTargetEcsTargetCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = Output.all(values)
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the task.
     */
    @JvmName("pwhyfaijjpntfdbs")
    public suspend fun enableEcsManagedTags(`value`: Output<Boolean>) {
        this.enableEcsManagedTags = value
    }

    /**
     * @param value Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
     */
    @JvmName("vxhmkgsllewgonhr")
    public suspend fun enableExecuteCommand(`value`: Output<Boolean>) {
        this.enableExecuteCommand = value
    }

    /**
     * @param value Specifies an ECS task group for the task. The maximum length is 255 characters.
     */
    @JvmName("qqaieekjktxwgjvg")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. Valid values include: `EC2`, `EXTERNAL`, or `FARGATE`.
     */
    @JvmName("ksgjfvdnxiypdwul")
    public suspend fun launchType(`value`: Output<String>) {
        this.launchType = value
    }

    /**
     * @param value Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
     */
    @JvmName("bycoeohvbyepnotf")
    public suspend
    fun networkConfiguration(`value`: Output<EventTargetEcsTargetNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
     */
    @JvmName("ihbdoaaxqqvsvdbu")
    public suspend
    fun orderedPlacementStrategies(`value`: Output<List<EventTargetEcsTargetOrderedPlacementStrategyArgs>>) {
        this.orderedPlacementStrategies = value
    }

    @JvmName("myodqtdnwwgimmpk")
    public suspend fun orderedPlacementStrategies(
        vararg
        values: Output<EventTargetEcsTargetOrderedPlacementStrategyArgs>,
    ) {
        this.orderedPlacementStrategies = Output.all(values.asList())
    }

    /**
     * @param values An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
     */
    @JvmName("xktdsxdrgvsopcep")
    public suspend
    fun orderedPlacementStrategies(values: List<Output<EventTargetEcsTargetOrderedPlacementStrategyArgs>>) {
        this.orderedPlacementStrategies = Output.all(values)
    }

    /**
     * @param value An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
     */
    @JvmName("daypohdimherjfxj")
    public suspend
    fun placementConstraints(`value`: Output<List<EventTargetEcsTargetPlacementConstraintArgs>>) {
        this.placementConstraints = value
    }

    @JvmName("cxkiijcmaonckhou")
    public suspend fun placementConstraints(
        vararg
        values: Output<EventTargetEcsTargetPlacementConstraintArgs>,
    ) {
        this.placementConstraints = Output.all(values.asList())
    }

    /**
     * @param values An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
     */
    @JvmName("tulpkaejmkehudhk")
    public suspend
    fun placementConstraints(values: List<Output<EventTargetEcsTargetPlacementConstraintArgs>>) {
        this.placementConstraints = Output.all(values)
    }

    /**
     * @param value Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`. This is used only if LaunchType is FARGATE. For more information about valid platform versions, see [AWS Fargate Platform Versions](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    @JvmName("wynxbtdvndxjhjgm")
    public suspend fun platformVersion(`value`: Output<String>) {
        this.platformVersion = value
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. The only valid value is: `TASK_DEFINITION`.
     */
    @JvmName("vceatfwuwkeggkuq")
    public suspend fun propagateTags(`value`: Output<String>) {
        this.propagateTags = value
    }

    /**
     * @param value A map of tags to assign to ecs resources.
     */
    @JvmName("ejodsnbjyhderhtw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of tasks to create based on the TaskDefinition. Defaults to `1`.
     */
    @JvmName("jnttyvhkknlvcqgj")
    public suspend fun taskCount(`value`: Output<Int>) {
        this.taskCount = value
    }

    /**
     * @param value The ARN of the task definition to use if the event target is an Amazon ECS cluster.
     */
    @JvmName("isirxpbqoydrrdkg")
    public suspend fun taskDefinitionArn(`value`: Output<String>) {
        this.taskDefinitionArn = value
    }

    /**
     * @param value The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
     */
    @JvmName("rqomvwapynllklmy")
    public suspend
    fun capacityProviderStrategies(`value`: List<EventTargetEcsTargetCapacityProviderStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
     */
    @JvmName("ixlejrshjhtpjamt")
    public suspend
    fun capacityProviderStrategies(argument: List<suspend EventTargetEcsTargetCapacityProviderStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventTargetEcsTargetCapacityProviderStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
     */
    @JvmName("ekrdvpcqeawpulnc")
    public suspend fun capacityProviderStrategies(
        vararg
        argument: suspend EventTargetEcsTargetCapacityProviderStrategyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventTargetEcsTargetCapacityProviderStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
     */
    @JvmName("wgpamuuhswwexlev")
    public suspend
    fun capacityProviderStrategies(argument: suspend EventTargetEcsTargetCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventTargetEcsTargetCapacityProviderStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param values The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
     */
    @JvmName("fmbyrcfqdwoklfib")
    public suspend fun capacityProviderStrategies(
        vararg
        values: EventTargetEcsTargetCapacityProviderStrategyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the task.
     */
    @JvmName("cnhcikxhmqqmbroc")
    public suspend fun enableEcsManagedTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEcsManagedTags = mapped
    }

    /**
     * @param value Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
     */
    @JvmName("wxhtymigwbmdtjfd")
    public suspend fun enableExecuteCommand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableExecuteCommand = mapped
    }

    /**
     * @param value Specifies an ECS task group for the task. The maximum length is 255 characters.
     */
    @JvmName("kresgytonefilffc")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. Valid values include: `EC2`, `EXTERNAL`, or `FARGATE`.
     */
    @JvmName("pauconayitqtsawt")
    public suspend fun launchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchType = mapped
    }

    /**
     * @param value Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
     */
    @JvmName("ugeesekmcusijgyl")
    public suspend fun networkConfiguration(`value`: EventTargetEcsTargetNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
     */
    @JvmName("qfwumjqqyuvpcjar")
    public suspend
    fun networkConfiguration(argument: suspend EventTargetEcsTargetNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = EventTargetEcsTargetNetworkConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
     */
    @JvmName("piiqilsuhynvhmii")
    public suspend
    fun orderedPlacementStrategies(`value`: List<EventTargetEcsTargetOrderedPlacementStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
     */
    @JvmName("eyvspjkrmpengxrg")
    public suspend
    fun orderedPlacementStrategies(argument: List<suspend EventTargetEcsTargetOrderedPlacementStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventTargetEcsTargetOrderedPlacementStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
     */
    @JvmName("jqfxvtolqieoqnox")
    public suspend fun orderedPlacementStrategies(
        vararg
        argument: suspend EventTargetEcsTargetOrderedPlacementStrategyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventTargetEcsTargetOrderedPlacementStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param argument An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
     */
    @JvmName("yiefkdskdlnjckrf")
    public suspend
    fun orderedPlacementStrategies(argument: suspend EventTargetEcsTargetOrderedPlacementStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventTargetEcsTargetOrderedPlacementStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param values An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
     */
    @JvmName("qbikjdnewbgcncel")
    public suspend fun orderedPlacementStrategies(
        vararg
        values: EventTargetEcsTargetOrderedPlacementStrategyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderedPlacementStrategies = mapped
    }

    /**
     * @param value An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
     */
    @JvmName("ibiybvxjaiqrtlri")
    public suspend
    fun placementConstraints(`value`: List<EventTargetEcsTargetPlacementConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
     */
    @JvmName("qtvfrmgvnydqhbiq")
    public suspend
    fun placementConstraints(argument: List<suspend EventTargetEcsTargetPlacementConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventTargetEcsTargetPlacementConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
     */
    @JvmName("ksdcxkjrhhawqmgt")
    public suspend fun placementConstraints(
        vararg
        argument: suspend EventTargetEcsTargetPlacementConstraintArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventTargetEcsTargetPlacementConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
     */
    @JvmName("mgrfngecbtouocci")
    public suspend
    fun placementConstraints(argument: suspend EventTargetEcsTargetPlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventTargetEcsTargetPlacementConstraintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param values An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
     */
    @JvmName("ughovxxwbqnraair")
    public suspend fun placementConstraints(
        vararg
        values: EventTargetEcsTargetPlacementConstraintArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param value Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`. This is used only if LaunchType is FARGATE. For more information about valid platform versions, see [AWS Fargate Platform Versions](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     */
    @JvmName("wabdwglxssldcdbt")
    public suspend fun platformVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformVersion = mapped
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. The only valid value is: `TASK_DEFINITION`.
     */
    @JvmName("wbkmsrftrngeoivu")
    public suspend fun propagateTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagateTags = mapped
    }

    /**
     * @param value A map of tags to assign to ecs resources.
     */
    @JvmName("tlpsayykvyicmmnn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to ecs resources.
     */
    @JvmName("ibmgqqrcdoonwemb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The number of tasks to create based on the TaskDefinition. Defaults to `1`.
     */
    @JvmName("kekhuyqnogcqricu")
    public suspend fun taskCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskCount = mapped
    }

    /**
     * @param value The ARN of the task definition to use if the event target is an Amazon ECS cluster.
     */
    @JvmName("oaxrqokvdjvliuwj")
    public suspend fun taskDefinitionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskDefinitionArn = mapped
    }

    internal fun build(): EventTargetEcsTargetArgs = EventTargetEcsTargetArgs(
        capacityProviderStrategies = capacityProviderStrategies,
        enableEcsManagedTags = enableEcsManagedTags,
        enableExecuteCommand = enableExecuteCommand,
        group = group,
        launchType = launchType,
        networkConfiguration = networkConfiguration,
        orderedPlacementStrategies = orderedPlacementStrategies,
        placementConstraints = placementConstraints,
        platformVersion = platformVersion,
        propagateTags = propagateTags,
        tags = tags,
        taskCount = taskCount,
        taskDefinitionArn = taskDefinitionArn ?: throw PulumiNullFieldException("taskDefinitionArn"),
    )
}
