@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetOrderedPlacementStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property field The field to apply the placement strategy against. For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`. For the `binpack` placement strategy, valid values are `cpu` and `memory`. For the `random` placement strategy, this field is not used. For more information, see [Amazon ECS task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
 * @property type Type of placement strategy. The only valid values at this time are `binpack`, `random` and `spread`.
 */
public data class EventTargetEcsTargetOrderedPlacementStrategyArgs(
    public val `field`: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetOrderedPlacementStrategyArgs> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetOrderedPlacementStrategyArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetEcsTargetOrderedPlacementStrategyArgs.builder()
            .`field`(`field`?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetEcsTargetOrderedPlacementStrategyArgs].
 */
@PulumiTagMarker
public class EventTargetEcsTargetOrderedPlacementStrategyArgsBuilder internal constructor() {
    private var `field`: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The field to apply the placement strategy against. For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`. For the `binpack` placement strategy, valid values are `cpu` and `memory`. For the `random` placement strategy, this field is not used. For more information, see [Amazon ECS task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
     */
    @JvmName("dpbmwqbummknvkpo")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value Type of placement strategy. The only valid values at this time are `binpack`, `random` and `spread`.
     */
    @JvmName("eyhkwivvsmlgkdui")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The field to apply the placement strategy against. For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`. For the `binpack` placement strategy, valid values are `cpu` and `memory`. For the `random` placement strategy, this field is not used. For more information, see [Amazon ECS task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
     */
    @JvmName("oqrhxgvwwuppviet")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value Type of placement strategy. The only valid values at this time are `binpack`, `random` and `spread`.
     */
    @JvmName("uuujxubbcrswrlmu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EventTargetEcsTargetOrderedPlacementStrategyArgs =
        EventTargetEcsTargetOrderedPlacementStrategyArgs(
            `field` = `field`,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
