@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetHttpTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property headerParameters Enables you to specify HTTP headers to add to the request.
 * @property pathParameterValues The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
 * @property queryStringParameters Represents keys/values of query string parameters that are appended to the invoked endpoint.
 * */*/
 */
public data class EventTargetHttpTargetArgs(
    public val headerParameters: Output<Map<String, String>>? = null,
    public val pathParameterValues: Output<List<String>>? = null,
    public val queryStringParameters: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetHttpTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetHttpTargetArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetHttpTargetArgs.builder()
            .headerParameters(
                headerParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .pathParameterValues(pathParameterValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .queryStringParameters(
                queryStringParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventTargetHttpTargetArgs].
 */
@PulumiTagMarker
public class EventTargetHttpTargetArgsBuilder internal constructor() {
    private var headerParameters: Output<Map<String, String>>? = null

    private var pathParameterValues: Output<List<String>>? = null

    private var queryStringParameters: Output<Map<String, String>>? = null

    /**
     * @param value Enables you to specify HTTP headers to add to the request.
     */
    @JvmName("ucitckmsmqaredtm")
    public suspend fun headerParameters(`value`: Output<Map<String, String>>) {
        this.headerParameters = value
    }

    /**
     * @param value The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
     * */*/
     */
    @JvmName("dcqelsaaukytwvny")
    public suspend fun pathParameterValues(`value`: Output<List<String>>) {
        this.pathParameterValues = value
    }

    @JvmName("rqvedjvdqucscubh")
    public suspend fun pathParameterValues(vararg values: Output<String>) {
        this.pathParameterValues = Output.all(values.asList())
    }

    /**
     * @param values The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
     * */*/
     */
    @JvmName("vlcnmystkbjbkefd")
    public suspend fun pathParameterValues(values: List<Output<String>>) {
        this.pathParameterValues = Output.all(values)
    }

    /**
     * @param value Represents keys/values of query string parameters that are appended to the invoked endpoint.
     */
    @JvmName("jcbmedokfachmdtn")
    public suspend fun queryStringParameters(`value`: Output<Map<String, String>>) {
        this.queryStringParameters = value
    }

    /**
     * @param value Enables you to specify HTTP headers to add to the request.
     */
    @JvmName("pcidfqxgdmvjpmbf")
    public suspend fun headerParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param values Enables you to specify HTTP headers to add to the request.
     */
    @JvmName("ngrwyflcgodrmjru")
    public fun headerParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param value The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
     * */*/
     */
    @JvmName("yrxjgbgifbdcanre")
    public suspend fun pathParameterValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathParameterValues = mapped
    }

    /**
     * @param values The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
     * */*/
     */
    @JvmName("bpksdswkmvjdnhbe")
    public suspend fun pathParameterValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pathParameterValues = mapped
    }

    /**
     * @param value Represents keys/values of query string parameters that are appended to the invoked endpoint.
     */
    @JvmName("fvvntaungsfuetuf")
    public suspend fun queryStringParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    /**
     * @param values Represents keys/values of query string parameters that are appended to the invoked endpoint.
     */
    @JvmName("cuqmannklbroefnv")
    public fun queryStringParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    internal fun build(): EventTargetHttpTargetArgs = EventTargetHttpTargetArgs(
        headerParameters = headerParameters,
        pathParameterValues = pathParameterValues,
        queryStringParameters = queryStringParameters,
    )
}
