@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property inputPaths Key value pairs specified in the form of JSONPath (for example, time = $.time)
 * * You can have as many as 100 key-value pairs.
 * * You must use JSON dot notation, not bracket notation.
 * * The keys can't start with "AWS".
 * @property inputTemplate Template to customize data sent to the target. Must be valid JSON. To send a string value, the string value must include double quotes.
 */
public data class EventTargetInputTransformerArgs(
    public val inputPaths: Output<Map<String, String>>? = null,
    public val inputTemplate: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs.builder()
            .inputPaths(
                inputPaths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .inputTemplate(inputTemplate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetInputTransformerArgs].
 */
@PulumiTagMarker
public class EventTargetInputTransformerArgsBuilder internal constructor() {
    private var inputPaths: Output<Map<String, String>>? = null

    private var inputTemplate: Output<String>? = null

    /**
     * @param value Key value pairs specified in the form of JSONPath (for example, time = $.time)
     * * You can have as many as 100 key-value pairs.
     * * You must use JSON dot notation, not bracket notation.
     * * The keys can't start with "AWS".
     */
    @JvmName("aioqxhvbvawatylh")
    public suspend fun inputPaths(`value`: Output<Map<String, String>>) {
        this.inputPaths = value
    }

    /**
     * @param value Template to customize data sent to the target. Must be valid JSON. To send a string value, the string value must include double quotes.
     */
    @JvmName("jektiwaqswinqiqn")
    public suspend fun inputTemplate(`value`: Output<String>) {
        this.inputTemplate = value
    }

    /**
     * @param value Key value pairs specified in the form of JSONPath (for example, time = $.time)
     * * You can have as many as 100 key-value pairs.
     * * You must use JSON dot notation, not bracket notation.
     * * The keys can't start with "AWS".
     */
    @JvmName("nmbhliepncvplicv")
    public suspend fun inputPaths(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputPaths = mapped
    }

    /**
     * @param values Key value pairs specified in the form of JSONPath (for example, time = $.time)
     * * You can have as many as 100 key-value pairs.
     * * You must use JSON dot notation, not bracket notation.
     * * The keys can't start with "AWS".
     */
    @JvmName("tsncvrilymqhorid")
    public fun inputPaths(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputPaths = mapped
    }

    /**
     * @param value Template to customize data sent to the target. Must be valid JSON. To send a string value, the string value must include double quotes.
     */
    @JvmName("lfgbxiawfnbfsyim")
    public suspend fun inputTemplate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputTemplate = mapped
    }

    internal fun build(): EventTargetInputTransformerArgs = EventTargetInputTransformerArgs(
        inputPaths = inputPaths,
        inputTemplate = inputTemplate ?: throw PulumiNullFieldException("inputTemplate"),
    )
}
