@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key Can be either `tag:tag-key` or `InstanceIds`.
 * @property values If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
 */
public data class EventTargetRunCommandTargetArgs(
    public val key: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EventTargetRunCommandTargetArgs].
 */
@PulumiTagMarker
public class EventTargetRunCommandTargetArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Can be either `tag:tag-key` or `InstanceIds`.
     */
    @JvmName("wuvkkmcxwmmchvlw")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
     */
    @JvmName("uxxquoadearbmhej")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("qxebaqvbmjjvptfc")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
     */
    @JvmName("arosgafgvpofxavc")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Can be either `tag:tag-key` or `InstanceIds`.
     */
    @JvmName("auwlggkekqjsskha")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
     */
    @JvmName("bbmgupnivqecsisv")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
     */
    @JvmName("dupxevjhfjwooris")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): EventTargetRunCommandTargetArgs = EventTargetRunCommandTargetArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
