@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.EventTargetSagemakerPipelineTargetPipelineParameterListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of parameter to start execution of a SageMaker Model Building Pipeline.
 * @property value Value of parameter to start execution of a SageMaker Model Building Pipeline.
 */
public data class EventTargetSagemakerPipelineTargetPipelineParameterListArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.EventTargetSagemakerPipelineTargetPipelineParameterListArgs> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.EventTargetSagemakerPipelineTargetPipelineParameterListArgs =
        com.pulumi.aws.cloudwatch.inputs.EventTargetSagemakerPipelineTargetPipelineParameterListArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventTargetSagemakerPipelineTargetPipelineParameterListArgs].
 */
@PulumiTagMarker
public class EventTargetSagemakerPipelineTargetPipelineParameterListArgsBuilder internal
constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    @JvmName("tmaibwekxirnoqgu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    @JvmName("owoxywdrdrpgwhib")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    @JvmName("mmngfjgwreqppnnw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    @JvmName("rnohlxltdxvfxfqy")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EventTargetSagemakerPipelineTargetPipelineParameterListArgs =
        EventTargetSagemakerPipelineTargetPipelineParameterListArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
