@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperation.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property audit Configures the detection of sensitive data.
 * @property deidentify Configures the masking of sensitive data.
 * > Every policy statement must specify exactly one operation.
 */
public data class GetLogDataProtectionPolicyDocumentStatementOperation(
    public val audit: GetLogDataProtectionPolicyDocumentStatementOperationAudit? = null,
    public val deidentify: GetLogDataProtectionPolicyDocumentStatementOperationDeidentify? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperation> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperation =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperation.builder()
            .audit(audit?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deidentify(deidentify?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentStatementOperation].
 */
@PulumiTagMarker
public class GetLogDataProtectionPolicyDocumentStatementOperationBuilder internal constructor() {
    private var audit: GetLogDataProtectionPolicyDocumentStatementOperationAudit? = null

    private var deidentify: GetLogDataProtectionPolicyDocumentStatementOperationDeidentify? = null

    /**
     * @param value Configures the detection of sensitive data.
     */
    @JvmName("srmqgmkytmyejkai")
    public suspend fun audit(`value`: GetLogDataProtectionPolicyDocumentStatementOperationAudit?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.audit = mapped
    }

    /**
     * @param argument Configures the detection of sensitive data.
     */
    @JvmName("fpccvlymxqawjnih")
    public suspend
    fun audit(argument: suspend GetLogDataProtectionPolicyDocumentStatementOperationAuditBuilder.() -> Unit) {
        val toBeMapped =
            GetLogDataProtectionPolicyDocumentStatementOperationAuditBuilder().applySuspend {
                argument()
            }.build()
        val mapped = toBeMapped
        this.audit = mapped
    }

    /**
     * @param value Configures the masking of sensitive data.
     * > Every policy statement must specify exactly one operation.
     */
    @JvmName("umafboerffulckmh")
    public suspend
    fun deidentify(`value`: GetLogDataProtectionPolicyDocumentStatementOperationDeidentify?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deidentify = mapped
    }

    /**
     * @param argument Configures the masking of sensitive data.
     * > Every policy statement must specify exactly one operation.
     */
    @JvmName("ejomswqkfplemiad")
    public suspend
    fun deidentify(argument: suspend GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyBuilder.() -> Unit) {
        val toBeMapped =
            GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyBuilder().applySuspend {
                argument()
            }.build()
        val mapped = toBeMapped
        this.deidentify = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentStatementOperation =
        GetLogDataProtectionPolicyDocumentStatementOperation(
            audit = audit,
            deidentify = deidentify,
        )
}
