@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAudit.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property findingsDestination Configures destinations to send audit findings to.
 */
public data class GetLogDataProtectionPolicyDocumentStatementOperationAudit(
    public val findingsDestination:
    GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAudit> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAudit =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAudit.builder()
            .findingsDestination(
                findingsDestination.let({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentStatementOperationAudit].
 */
@PulumiTagMarker
public class GetLogDataProtectionPolicyDocumentStatementOperationAuditBuilder internal constructor() {
    private var findingsDestination:
        GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination? = null

    /**
     * @param value Configures destinations to send audit findings to.
     */
    @JvmName("keynkmpxjllofgik")
    public suspend
    fun findingsDestination(`value`: GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.findingsDestination = mapped
    }

    /**
     * @param argument Configures destinations to send audit findings to.
     */
    @JvmName("enswmrjhihvnynxj")
    public suspend
    fun findingsDestination(argument: suspend GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationBuilder.() -> Unit) {
        val toBeMapped =
            GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationBuilder().applySuspend {
                argument()
            }.build()
        val mapped = toBeMapped
        this.findingsDestination = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentStatementOperationAudit =
        GetLogDataProtectionPolicyDocumentStatementOperationAudit(
            findingsDestination = findingsDestination ?: throw PulumiNullFieldException("findingsDestination"),
        )
}
