@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogs Configures CloudWatch Logs as a findings destination.
 * @property firehose Configures Kinesis Firehose as a findings destination.
 * @property s3 Configures S3 as a findings destination.
 */
public data class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination(
    public val cloudwatchLogs:
    GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs? =
        null,
    public val firehose:
    GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose? = null,
    public val s3: GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination.builder()
            .cloudwatchLogs(cloudwatchLogs?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firehose(firehose?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3(s3?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination].
 */
@PulumiTagMarker
public class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationBuilder
internal constructor() {
    private var cloudwatchLogs:
        GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs? =
        null

    private var firehose:
        GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose? = null

    private var s3: GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3? =
        null

    /**
     * @param value Configures CloudWatch Logs as a findings destination.
     */
    @JvmName("emfhpavfwtlawvrb")
    public suspend
    fun cloudwatchLogs(`value`: GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument Configures CloudWatch Logs as a findings destination.
     */
    @JvmName("uwdnffuacpxscjux")
    public suspend
    fun cloudwatchLogs(argument: suspend GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsBuilder.() -> Unit) {
        val toBeMapped =
            GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = toBeMapped
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value Configures Kinesis Firehose as a findings destination.
     */
    @JvmName("fgdyvlwvapvgrtdy")
    public suspend
    fun firehose(`value`: GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.firehose = mapped
    }

    /**
     * @param argument Configures Kinesis Firehose as a findings destination.
     */
    @JvmName("gqicwaepooruyyqm")
    public suspend
    fun firehose(argument: suspend GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseBuilder.() -> Unit) {
        val toBeMapped =
            GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseBuilder().applySuspend {
                argument()
            }.build()
        val mapped = toBeMapped
        this.firehose = mapped
    }

    /**
     * @param value Configures S3 as a findings destination.
     */
    @JvmName("rxdtkhndgdcashik")
    public suspend
    fun s3(`value`: GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.s3 = mapped
    }

    /**
     * @param argument Configures S3 as a findings destination.
     */
    @JvmName("fjutfeqbxmuuiolg")
    public suspend
    fun s3(argument: suspend GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Builder.() -> Unit) {
        val toBeMapped =
            GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Builder().applySuspend {
                argument()
            }.build()
        val mapped = toBeMapped
        this.s3 = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination =
        GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestination(
            cloudwatchLogs = cloudwatchLogs,
            firehose = firehose,
            s3 = s3,
        )
}
