@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationDeidentify.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property maskConfig An empty object that configures masking.
 */
public data class GetLogDataProtectionPolicyDocumentStatementOperationDeidentify(
    public val maskConfig: GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfig,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationDeidentify> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationDeidentify =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationDeidentify.builder()
            .maskConfig(maskConfig.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentStatementOperationDeidentify].
 */
@PulumiTagMarker
public class GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyBuilder internal
constructor() {
    private var maskConfig: GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfig? =
        null

    /**
     * @param value An empty object that configures masking.
     */
    @JvmName("digmdmvxnhftiahu")
    public suspend
    fun maskConfig(`value`: GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfig) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.maskConfig = mapped
    }

    /**
     * @param argument An empty object that configures masking.
     */
    @JvmName("gmqwxtomdeoadeny")
    public suspend
    fun maskConfig(argument: suspend GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigBuilder.() -> Unit) {
        val toBeMapped =
            GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigBuilder().applySuspend {
                argument()
            }.build()
        val mapped = toBeMapped
        this.maskConfig = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentStatementOperationDeidentify =
        GetLogDataProtectionPolicyDocumentStatementOperationDeidentify(
            maskConfig = maskConfig ?: throw PulumiNullFieldException("maskConfig"),
        )
}
